PRAGMA foreign_keys = OFF;

-- ----------------------------
-- Table structure for accounts
-- ----------------------------
DROP TABLE IF EXISTS "accounts";
CREATE TABLE "accounts" (
"account_id"  INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
"account_desc"  varchar(150) COLLATE NOCASE
)

;

-- ----------------------------
-- Records of accounts
-- ----------------------------
INSERT INTO "accounts" VALUES (1, 'Wallet');
INSERT INTO "accounts" VALUES (2, 'Bank');
INSERT INTO "accounts" VALUES (3, 'Credit Card');
INSERT INTO "accounts" VALUES (4, 'Savings');

-- ----------------------------
-- Table structure for categories
-- ----------------------------
DROP TABLE IF EXISTS "categories";
CREATE TABLE "categories" (
"category_id"  INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
"category_desc"  varchar(150) COLLATE NOCASE NOT NULL,
"category_ico"  blob,
"category_master"  INTEGER,
FOREIGN KEY ("category_master") REFERENCES "categories" ("category_id")
)

;

-- ----------------------------
-- Records of categories
-- ----------------------------
INSERT INTO "categories" VALUES (1, 'TRANSFER', X'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', null);
INSERT INTO "categories" VALUES (2, 'transfer in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
INSERT INTO "categories" VALUES (3, 'transfer out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
INSERT INTO "categories" VALUES (4, 'CREDITS', X'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', null);
INSERT INTO "categories" VALUES (5, 'salary', null, 4);
INSERT INTO "categories" VALUES (6, 'bonus', null, 4);
INSERT INTO "categories" VALUES (7, 'commission', null, 4);
INSERT INTO "categories" VALUES (8, 'reversal', null, 4);
INSERT INTO "categories" VALUES (9, 'vacation', null, 4);
INSERT INTO "categories" VALUES (10, 'fees', null, 4);
INSERT INTO "categories" VALUES (11, 'interest fro', null, 4);
INSERT INTO "categories" VALUES (12, 'refund', null, 4);
INSERT INTO "categories" VALUES (13, 'gift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
INSERT INTO "categories" VALUES (14, 'other (', null, 4);
INSERT INTO "categories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null);
INSERT INTO "categories" VALUES (16, 'mortgage/rent', null, 15);
INSERT INTO "categories" VALUES (17, 'electricity', null, 15);
INSERT INTO "categories" VALUES (18, 'gas/oil', null, 15);
INSERT INTO "categories" VALUES (19, 'water/sewer/trash', null, 15);
INSERT INTO "categories" VALUES (20, 'phone', null, 15);
INSERT INTO "categories" VALUES (21, 'cable/satellite', null, 15);
INSERT INTO "categories" VALUES (22, 'internet', null, 15);
INSERT INTO "categories" VALUES (23, 'furnishings/appliances', null, 15);
INSERT INTO "categories" VALUES (24, 'lawn/', null, 15);
INSERT INTO "categories" VALUES (25, 'home supplies', null, 15);
INSERT INTO "categories" VALUES (26, 'maintenance', null, 15);
INSERT INTO "categories" VALUES (27, 'improvements', null, 15);
INSERT INTO "categories" VALUES (28, 'other (home)', null, 15);
INSERT INTO "categories" VALUES (29, 'DAILY LIVING', X'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', null);
INSERT INTO "categories" VALUES (30, 'groceries', null, 29);
INSERT INTO "categories" VALUES (31, 'personal supplies', null, 29);
INSERT INTO "categories" VALUES (32, 'clothing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
INSERT INTO "categories" VALUES (33, 'cleaning', null, 29);
INSERT INTO "categories" VALUES (34, 'dining/eating out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
INSERT INTO "categories" VALUES (35, 'dry cleaning', null, 29);
INSERT INTO "categories" VALUES (36, 'salon/barber', null, 29);
INSERT INTO "categories" VALUES (37, 'other (daily living)', null, 29);
INSERT INTO "categories" VALUES (38, 'CHILDREN', X'89504E470D0A1A0A0000000D49484452000000400000004008030000009DB781EC0000000373424954080808DBE14FE00000000970485973000001BB000001BB013AECE3E20000001974455874536F667477617265007777772E696E6B73636170652E6F72679BEE3C1A0000027F504C5445FFFFFFAAAAAA80CCCC80BFD584C6D08CC5CE88C4CC8AC6CD89C4CB87C6CB87C4CC87C4CC89C6CD88C6CC89C6CB88C6CD87C5CC88C5CC88C6CD88C5CC87C5CD88C5CB88C6CC88C5CC88C5CC88C5CC88C5CC88C5CC88C5CC88C5CC1E2C331E2D341F2D351F2E35202E35202F36202F37212F3721313922313822313922323A23323B23333A23343C24242424252624353E252F3325303525313825353E25363E25363F26363E26363F2637402638412739422838412A2D2E2A363B2A3E452B3E472C3C422D4049324951324952333333354D55364F56374F583A545D3C565F3D585F405C6542595E425F68436168454F4C4B6D744B6D754C6E764D3F434D6F774E717A505A5B51767E525951547A81567D85577E86587F87595F545982895B7D815B848B5D5D5D61655762878B638F976390976B969B6B9BA36FA1A870A2A971725D71A4AC73737373A6AE74A9B078AEB579AFB67A7A7A7DB5BC80B9C081BAC184816486826586C2C986C3CA87C4CB88C5CC89C5CB8AC5CC8BC5CA8EC6C88EDACF8FDCCF90C7CB92C6C592DDD596C8CA96E5D896E6D9978F6C97C6C197E6D899E5D79ACAC99DC7BD9EC7BDA0C7BBA4A391A5C7B8A89D72A95149A9A9A9AACEC7AB534BACC8B3AD544BAECFC6AEDEC1B0CFC6B1B1B1B3B3B3B5DCBAB6C9ACB8AB7AB9D1C4BCD2C4BFCAA5C5D7ABC86955C8CA9FC9D5C1CC584CCCD5A3CCD6C1CD6D57D0CB9AD6CC95D7D8BED8C285D8D8BEDBCC92DCCC91DCD9BDDDD9BDDFC887DFCC8FDFDABCDFDBBEE0B17BE0C988E0DABCE3CD8CE3CE8DE3DABBE4CB89E4DABAE5CD8BE5DABAE6CD8AE6D9B8E6DAB9E6DFC0E7DAB9E8DBBAE9DCBAEADDBBEBDEBCECD28DEDE0BEEEE1BEEEE1BFEFE2C0F0E3C0F0E3C1F1E4C1F2D891F2E5C2B348594F0000001E74524E5300030A0C1B1F3C4C4E62646870748A8EA4B0B6BEC0CBD5D8E5EAF2F8F9FE6DF304EA000003824944415458C3AD57F75BD350144D99A59B96522810455CA84141C5A875D7BDC52D8A582D0E1C20883E372AA2E20277710F545071E01E98202A2220E40FB294F6E585264DF2C1F9A9F7FBEE397DB9F7BEFBEEC53001042B353A83C962B55A4C069D46198CC94288DA1807388833AA43A4B283B4E604C08304B33648025DA18A0182885129C4F8E1D12020A2C303D243A38028A24285F961B1400262C384F811F14012E223F8A3A70792A1E789A52212C840A4BF821EC882DEEFFB814C748B43987FFC762E9B447A306B63115F2439B908F5CFDFBE6924C47986696FFDF1EED59D036836D17AE0A99F1C72ED870E0F6E93CB190FFE35353C422B0AA95F9E23AE21F7FCE912E82049C68B96C68FC7591758D58A68A9024C7B63C319F65EF872A90292059836FADB51E8A3F2DEFF181902CC5FFA357BBBBBFA8316C811607ED1D7A093D623609627D04A7F814E664FFF4B9027E03EC20DD8E53AFBA41AC81468A65F402FB55BC0E833CE9E9326D04E37C08A34BAFB3FECDF2FA95B9204989FF425D8ED833125A45CA9A7EEED9722F09BBE0BDD949886FDD30B9FA88707250834D14F204783E9906397D551D587C4059AE96790A2C30C68E44A6BA99A62518116FA2D641830132779C535546DA998401BFD1D124C98859BFE43D5545D9988803B8FD0DF82597D3F8F957870FA31F5F97A49609C3872D8C7B2FA09949CBA4FD5DF9421C07EC24C5F0B2CA4A842320086E343914F6083381F7A6CFD4A9D1C2F2C300C9F8804914DE352D665C31BEAE2644181647C3A9246B69032119F95CFDF3FB89C212030105F8014125BCA9B50A7854FABAACA0504FAE3AB9052662FD3168ED7556181443C07B94CEC752E9A827A6594970B7CC2487C1040AE33DB50C062521206E37300D2509096B6599A405F7C1BA7A5214D75AE147E323E03709A2AD2D6778C15E78FEED32F9FDBD6D18725535C20095F0FBA3D2CE8D3B6448C3F005F01BA3F6DE8E3BA77F5B84EB7F4B41169E908CD678F4A4A5A87340F15DFF3BE7D3649A6A6100491920AF95E7BCC90C4A9F9E8D8ABE01F3076CD23087BB69D207C0AA95E7BC2A2DD1CC7708111A7C046E4BA2A5DB984AD80D7E61971B8439693B0BB2AF22A5C76C2C96BF30D599C312F8BC8AECC23F22AB3892C5E9B6FCCE30C9AD24E10213CEA4A8A813ED0B0EDF046DD2160F30FDBE8B8EFB0B9F36E7308DABCE33E67E128706639D19C716D8185A317569E9E2F5D3D5FFB7A61F1ECF9EADB0BCBB7BCF5FF3F14929B03264933FF0000000049454E44AE426082', null);
INSERT INTO "categories" VALUES (39, 'medical', null, 38);
INSERT INTO "categories" VALUES (40, 'clot', null, 38);
INSERT INTO "categories" VALUES (41, 'school tuition', null, 38);
INSERT INTO "categories" VALUES (42, 'school lunch', null, 38);
INSERT INTO "categories" VALUES (43, 'school supplies', null, 38);
INSERT INTO "categories" VALUES (44, 'babysitting', null, 38);
INSERT INTO "categories" VALUES (45, 'toys/games', null, 38);
INSERT INTO "categories" VALUES (46, 'other (children)', null, 38);
INSERT INTO "categories" VALUES (47, 'TRANSPO', X'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', null);
INSERT INTO "categories" VALUES (48, 'vehicle ', null, 47);
INSERT INTO "categories" VALUES (49, 'fuel', X'89504E470D0A1A0A0000000D4948445200000040000000400806000000AA6971DE000000097048597300000B1300000B1301009A9C180000001974455874536F6674776172650041646F626520496D616765526561647971C9653C0000050A4944415478DAEC5B4B4F5B4714FEB8606A02C43644C401118C08956849E2B428120835348D2AA12E6ADA65A5969F9055D5A517EDB6625FA9B23755362D66D348DDD46411A94A5B7053A9695552A3C4E5516230F88D319DB91A8363DFF7BD7E717DA4A32BC39DB9F37D73CE9933AF96E3E3635452D6D77F9B210FAA6EA22EA2D7658A84888689AE120D0E0D5D0B56B27D2D46134000DBC9C3C3F47D83AA5D221AA04A08D9AB4B02584FCF13FD0495153FD10542C46A5D10C0807B89DE427565997E57AF8B68268099FA42157A5C8945DCD5EA1A9A0820E0A97FFB88DA501F12A3EE474808A82DC869004F812FD61178B0B62CB2B655C60298C907150C63B5163A8CCE287509EE8C81076B6390B559BF05908A5C2C29B1A1B184C605979C25700A7A3ED080E00B7141D612E45CA051CC5ED21D3411C0226A23833F21416A74108C016C9C5FC4D99239A13CA18C00E6336131BFFF69650D8BDF3F422A9DC5D5B1415C713971EDB541F4D8BB14B764FBCBAF7014D53EA7E9B8318EEEDB536875A80A4D82415188009F547AFBD917F778F0A572F3C6086626C73070A9A7A2E04F1A6E7D05F60F67611D1B5595361302E6450960139B1FA56AF8F4F36F90C9E444FF7F8B90307BFB3A3AACED886C44F11DB196824C6F3C85331D37D4AEED1FCCA2E38D713545DE2E9E40B57ABDDE531B896DF9D8A285A8A4E27144B66238CA0BE70FEBCF77F0EBE37F60EB3E87AFEF2D637B671FD1BD0426773730924B1AEED8E93FFE469BDD06CBA53EA54586EDF68BBE320B20BD4F576C56E44AFFF5E71AFFDCD94DE0C9DA369E3E7B818344A6DC448916287AEF781F5791520DEE706408E9A9374F87AC680C1D0F7F06B71B2B7BD7F191478D3B9C5841F130785749C9DE5E07FFBCE0E8C4F4C4303E9E9BC03B93A368B7B4BEF49E5EF0542C6BEBB03EFCE5E477BEC786E4BB6F212F10FCF6BEBD8F2301624464FE250B60917F5769E97C3E8F783C81643285FDD801FFB74C3687FB0F9E20B279DA083DE04BA33E0D78E974065B9BDBC81E2470EE8707659650784FA138E88850B0008FAA3934C7E1FCF96E389D7DB8323ACC5B057583FF5EC40D07CFC79D95DFF91EB692C83F787900EDDD9D829640DF53219E6217F0686D1C25A3F7420F1E3D8E207B786438F85212E8F70A24A4A626F454C9636E633F74AFDEE65930AD04F8D21EA6664E4978A6AF3A1E33C7C67EDD92CD1E5614BC90255C74F6E9AA8B62A71660080177A2CFD15F61F04296A0537802DC7A6BA1E96D7F36896A8ACA8027266E4E2EF3ABF4C4A6C624B838BD73FE5A81376AAD8083C9A54940938026014D02B4A7BFE98CB909E0C8ECEC2C101032B10784280161131310A604AC9A9880554A40D0C40404B94A9FC3AB67A1D80BA3C09209F12F150F83011312106812502080ED98FA4D04DE5FD8252ECE047D262260A12C1566A3C1B209C02F179F332E9D0B781B1A5A4B8B92B7BCA293216605AA6241EE727FDDE0CFBE3EAAC4F78372B341BA4BAC789B357767BAF624909ECF8EBF8AFC4DC915FE180476C0751F92A2BBC4FF4636EBC202FA079CE8EAEA14FBB7E021294E24450C287505FA41FA618BA5AD66C0E9B765C0FBC54E924B1E95259640A365A39F150C11F06EA90511299941632F988420B3F7A9E4B0B4E4B9C13A161AF4DCA4F7C3522FC9AE09B294D1D5609640DBEA9203AF888022121AC51D545D98507D6748EE24691D4C72E6D51450BD2CCE3E30A72659AA92BFCFA905AF8980A23CC1552753683FF3774D6B1ACD8B93065E9D75B35CBB1A57677D462DE6362F4F9BFDFAFCFF020C00A31C2648739CD0240000000049454E44AE426082', 47);
INSERT INTO "categories" VALUES (50, 'bus/taxi/train fare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
INSERT INTO "categories" VALUES (51, 'repairs', null, 47);
INSERT INTO "categories" VALUES (52, 'registration/license', null, 47);
INSERT INTO "categories" VALUES (53, 'parking', null, 47);
INSERT INTO "categories" VALUES (54, 'other (transportation)', null, 47);
INSERT INTO "categories" VALUES (55, 'HEALTH', X'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', null);
INSERT INTO "categories" VALUES (56, 'doctor/dentist', null, 55);
INSERT INTO "categories" VALUES (57, 'medicine/drugs', null, 55);
INSERT INTO "categories" VALUES (58, 'health club dues', null, 55);
INSERT INTO "categories" VALUES (59, 'emergency', null, 55);
INSERT INTO "categories" VALUES (60, 'other (health)', null, 55);
INSERT INTO "categories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null);
INSERT INTO "categories" VALUES (62, 'auto', null, 61);
INSERT INTO "categories" VALUES (63, 'health', null, 61);
INSERT INTO "categories" VALUES (64, 'home/rental', null, 61);
INSERT INTO "categories" VALUES (65, 'life', null, 61);
INSERT INTO "categories" VALUES (66, 'other (insurance)', null, 61);
INSERT INTO "categories" VALUES (67, 'EDUCATION', X'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', null);
INSERT INTO "categories" VALUES (68, 'tuition', null, 67);
INSERT INTO "categories" VALUES (69, 'books', null, 67);
INSERT INTO "categories" VALUES (70, 'music lessons', null, 67);
INSERT INTO "categories" VALUES (71, 'other (education)', null, 67);
INSERT INTO "categories" VALUES (72, 'CHARITY', X'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', null);
INSERT INTO "categories" VALUES (73, 'gifts given', null, 72);
INSERT INTO "categories" VALUES (74, 'charitable donations', null, 72);
INSERT INTO "categories" VALUES (75, 'religious donations', null, 72);
INSERT INTO "categories" VALUES (76, 'other (charity)', null, 72);
INSERT INTO "categories" VALUES (77, 'SAVINGS', X'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', null);
INSERT INTO "categories" VALUES (78, 'emergency fund', null, 77);
INSERT INTO "categories" VALUES (79, 'transfer to savings', null, 77);
INSERT INTO "categories" VALUES (80, 'retirement (401k, ira)', null, 77);
INSERT INTO "categories" VALUES (81, 'investments', null, 77);
INSERT INTO "categories" VALUES (82, 'college', null, 77);
INSERT INTO "categories" VALUES (83, 'other (savings)', null, 77);
INSERT INTO "categories" VALUES (84, 'OBLIGATIONS', '', null);
INSERT INTO "categories" VALUES (85, 'student loan', null, 84);
INSERT INTO "categories" VALUES (86, 'other loan', null, 84);
INSERT INTO "categories" VALUES (87, 'credit card #1', null, 84);
INSERT INTO "categories" VALUES (88, 'credit card #2', null, 84);
INSERT INTO "categories" VALUES (89, 'credit card #3', null, 84);
INSERT INTO "categories" VALUES (90, 'alimony/child support', null, 84);
INSERT INTO "categories" VALUES (91, 'federal taxes', null, 84);
INSERT INTO "categories" VALUES (92, 'property tax', null, 84);
INSERT INTO "categories" VALUES (93, 'state/local taxes', null, 84);
INSERT INTO "categories" VALUES (94, 'hoa fees', null, 84);
INSERT INTO "categories" VALUES (95, 'legal fees', null, 84);
INSERT INTO "categories" VALUES (96, 'other (obligations)', null, 84);
INSERT INTO "categories" VALUES (97, 'ENTERTAINMENT', X'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', null);
INSERT INTO "categories" VALUES (98, 'videos/dvds', null, 97);
INSERT INTO "categories" VALUES (99, 'music', null, 97);
INSERT INTO "categories" VALUES (100, 'games', null, 97);
INSERT INTO "categories" VALUES (101, 'rentals', null, 97);
INSERT INTO "categories" VALUES (102, 'movies/', null, 97);
INSERT INTO "categories" VALUES (103, 'concerts/plays', null, 97);
INSERT INTO "categories" VALUES (104, 'books', null, 97);
INSERT INTO "categories" VALUES (105, 'hobbies', null, 97);
INSERT INTO "categories" VALUES (106, 'film/photos', null, 97);
INSERT INTO "categories" VALUES (107, 'sports', null, 97);
INSERT INTO "categories" VALUES (108, 'outdoor recreation', null, 97);
INSERT INTO "categories" VALUES (109, 'toys/gadgets', null, 97);
INSERT INTO "categories" VALUES (110, 'other (ente', null, 97);
INSERT INTO "categories" VALUES (111, 'PETS', X'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', null);
INSERT INTO "categories" VALUES (112, 'food', null, 111);
INSERT INTO "categories" VALUES (113, 'medical', null, 111);
INSERT INTO "categories" VALUES (114, 'toys/supplies', null, 111);
INSERT INTO "categories" VALUES (115, 'other (pets)', null, 111);
INSERT INTO "categories" VALUES (116, 'SUBSCRIPTIONS', X'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', null);
INSERT INTO "categories" VALUES (117, 'newspaper', null, 116);
INSERT INTO "categories" VALUES (118, 'magazines', null, 116);
INSERT INTO "categories" VALUES (119, 'dues', null, 116);
INSERT INTO "categories" VALUES (120, 'club memberships', null, 116);
INSERT INTO "categories" VALUES (121, 'other (subscriptions)', null, 116);
INSERT INTO "categories" VALUES (122, 'VACATION', X'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', null);
INSERT INTO "categories" VALUES (123, 'travel', null, 122);
INSERT INTO "categories" VALUES (124, 'lodging', null, 122);
INSERT INTO "categories" VALUES (125, 'food', null, 122);
INSERT INTO "categories" VALUES (126, 'rental car', null, 122);
INSERT INTO "categories" VALUES (127, 'entertainment', null, 122);
INSERT INTO "categories" VALUES (128, 'other (vacation)', null, 122);
INSERT INTO "categories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null);
INSERT INTO "categories" VALUES (130, 'bank fees', null, 129);
INSERT INTO "categories" VALUES (131, 'postage', null, 129);
INSERT INTO "categories" VALUES (132, 'other (miscellaneous)', null, 129);
INSERT INTO "categories" VALUES (133, 'cash withdrawal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
INSERT INTO "categories" VALUES (134, 'deposit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

-- ----------------------------
-- Table structure for planning_goals
-- ----------------------------
DROP TABLE IF EXISTS "planning_goals";
CREATE TABLE "planning_goals" (
"planning_goals_id"  INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
"planning_goals_desc"  varchar(150) COLLATE NOCASE NOT NULL,
"user_login"  varchar(150) COLLATE NOCASE NOT NULL,
"planning_goals_start_date"  datetime,
"planning_goals_end_date"  datetime,
"planning_goals_avg_incoming"  double,
"planning_goals_starting"  double,
"planning_goals_save"  double,
"planning_goals_total_cost"  double,
"planning_goals_completed"  varchar(5) COLLATE NOCASE,
"planning_goals_type_id"  INTEGER,
FOREIGN KEY ("user_login") REFERENCES "sec_users" ("user_login"),
FOREIGN KEY ("planning_goals_type_id") REFERENCES "planning_goals_type" ("planning_goals_type_id")
)

;

-- ----------------------------
-- Records of planning_goals
-- ----------------------------
INSERT INTO "planning_goals" VALUES (1, 'Euro', 'sample', '2017-08-22 00:00:00', '2017-12-21 00:00:00', 481.154771451484, 6000.0, 300.0, 15000.0, 'N', 2);
INSERT INTO "planning_goals" VALUES (2, 'Control m', 'sample', '2017-08-23 00:00:00', '2017-10-31 00:00:00', 3000.0, 0.0, 300.0, 5400.0, 'N', 1);

-- ----------------------------
-- Table structure for planning_goals_type
-- ----------------------------
DROP TABLE IF EXISTS "planning_goals_type";
CREATE TABLE "planning_goals_type" (
"planning_goals_type_id"  INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
"planning_goals_typ_desc"  varchar(150) COLLATE NOCASE
)

;

-- ----------------------------
-- Records of planning_goals_type
-- ----------------------------
INSERT INTO "planning_goals_type" VALUES (1, 'Control Expenses and Save Money');
INSERT INTO "planning_goals_type" VALUES (2, 'How much saving to reach the target?');

-- ----------------------------
-- Table structure for sec_users
-- ----------------------------
DROP TABLE IF EXISTS "sec_users";
CREATE TABLE "sec_users" (
"user_login"  varchar(50) COLLATE NOCASE NOT NULL,
"user_name"  varchar(150) COLLATE NOCASE NOT NULL,
"user_email"  varchar(150) COLLATE NOCASE NOT NULL,
"user_password"  varchar(50) COLLATE NOCASE,
"user_active"  varchar(5) COLLATE NOCASE,
"user_dt_insert"  datetime,
"user_dt_expire"  datetime,
"activation_code"  varchar(150) COLLATE NOCASE,
"priv_admin"  INTEGER,
PRIMARY KEY ("user_login" ASC)
)

;

-- ----------------------------
-- Records of sec_users
-- ----------------------------
INSERT INTO "sec_users" VALUES ('sample', 'Sample User', 'samples@scriptcase.net', '81dc9bdb52d04dc20036dbd8313ed055', 'Y', '2017-08-02 00:00:00', null, null, 1);

-- ----------------------------
-- Table structure for transaction_types
-- ----------------------------
DROP TABLE IF EXISTS "transaction_types";
CREATE TABLE "transaction_types" (
"transaction_types_id"  INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
"transaction_types_desc"  varchar(150) COLLATE NOCASE
)

;

-- ----------------------------
-- Records of transaction_types
-- ----------------------------
INSERT INTO "transaction_types" VALUES (1, 'Transfer');
INSERT INTO "transaction_types" VALUES (2, 'Income');
INSERT INTO "transaction_types" VALUES (3, 'Expense');

-- ----------------------------
-- Table structure for transactions_account
-- ----------------------------
DROP TABLE IF EXISTS "transactions_account";
CREATE TABLE "transactions_account" (
"transaction_id"  INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
"user_login"  varchar(50) COLLATE NOCASE NOT NULL,
"account_id"  INTEGER NOT NULL,
"transaction_types_id"  INTEGER NOT NULL,
"category_id"  INTEGER NOT NULL,
"transfer_transaction_id"  INTEGER,
"transfer_to"  INTEGER,
"transaction_projected_amount"  double,
"transaction_actual_amount"  double,
"transaction_date"  date,
"transaction_time_notif"  time,
"transaction_desc"  varchar(150) COLLATE NOCASE,
"transaction_consumed"  varchar(5) COLLATE NOCASE,
"transaction_recurrence"  varchar(5) COLLATE NOCASE,
"transaction_period"  varchar(150) COLLATE NOCASE,
"transaction_num"  INTEGER,
"transaction_num_total"  INTEGER,
"transaction_balance_account"  double,
"transaction_balance_all"  double,
FOREIGN KEY ("category_id") REFERENCES "categories" ("category_id"),
FOREIGN KEY ("transaction_types_id") REFERENCES "transaction_types" ("transaction_types_id"),
FOREIGN KEY ("transfer_transaction_id") REFERENCES "transactions_account" ("transaction_id"),
FOREIGN KEY ("user_login", "account_id") REFERENCES "user_account" ("user_login", "account_id")
)

;

-- ----------------------------
-- Records of transactions_account
-- ----------------------------
INSERT INTO "transactions_account" VALUES (14, 'sample', 2, 3, 32, null, null, 0.0, 174.0, '2017-08-07', null, '', 'Y', 'N', '', 1, 1, 2846.4, 7439.3);
INSERT INTO "transactions_account" VALUES (15, 'sample', 1, 2, 10, null, null, 0.0, 26.6238973536488, '2017-08-07', null, '', 'Y', 'N', '', 1, 1, 4988.9, 7905.3);
INSERT INTO "transactions_account" VALUES (16, 'sample', 2, 1, 133, null, 1, 0.0, 230.0, '2017-08-07', null, '', 'Y', 'N', '', 1, 0, 2616.4, 7439.3);
INSERT INTO "transactions_account" VALUES (17, 'sample', 2, 3, 3, 16, null, null, 230.0, '2017-08-07', null, '', 'Y', 'N', null, null, null, 2616.4, 7209.3);
INSERT INTO "transactions_account" VALUES (18, 'sample', 1, 2, 2, 16, null, null, 230.0, '2017-08-07', null, '', 'Y', 'N', null, null, null, 4822.9, 7439.3);
INSERT INTO "transactions_account" VALUES (19, 'sample', 1, 1, 134, null, 2, 0.0, 300.0, '2017-08-07', null, '', 'Y', 'N', '', 1, 1, 4592.9, 7439.3);
INSERT INTO "transactions_account" VALUES (20, 'sample', 1, 3, 3, 19, null, null, 300.0, '2017-08-07', null, '', 'Y', 'N', null, null, null, 736.63191659984, 7613.3);
INSERT INTO "transactions_account" VALUES (21, 'sample', 2, 2, 2, 19, null, null, 300.0, '2017-08-07', null, '', 'Y', '', null, null, null, 2916.4, 7739.3);
INSERT INTO "transactions_account" VALUES (25, 'sample', 2, 3, 32, null, null, 0.0, 37.0, '2017-08-08', null, '', 'Y', 'Y', 'M', 1, 4, 2879.4, 7868.3);
INSERT INTO "transactions_account" VALUES (26, 'sample', 2, 3, 32, 25, null, null, 37.0, '2017-09-08', null, '', 'N', 'Y', 'M', 2, 4, 6031.4, 7752.3);
INSERT INTO "transactions_account" VALUES (27, 'sample', 2, 3, 32, 25, null, null, 37.0, '2017-10-08', null, '', 'N', 'Y', 'M', 3, 4, 967.345629510826, 7752.3);
INSERT INTO "transactions_account" VALUES (28, 'sample', 2, 3, 32, 25, null, null, 37.0, '2017-11-08', null, '', '', 'Y', '', 4, 4, 6031.4, 7752.3);
INSERT INTO "transactions_account" VALUES (29, 'sample', 1, 3, 34, null, null, 0.0, 33.0, '2017-08-09', null, '', 'Y', 'N', '', 1, 1, 4955.9, 7535.3);
INSERT INTO "transactions_account" VALUES (30, 'sample', 2, 2, 13, null, null, 0.0, 583.0, '2017-08-16', null, '', 'Y', 'N', '', 1, 1, 2897.4, 7835.3);
INSERT INTO "transactions_account" VALUES (34, 'sample', 2, 1, 133, null, 1, 0.0, 150.0, '2017-08-16', null, '', 'Y', '', '', 1, 1, 2464.4, 7252.3);
INSERT INTO "transactions_account" VALUES (35, 'sample', 2, 3, 3, 34, null, null, 150.0, '2017-08-16', null, null, 'Y', 'N', null, null, null, 2314.4, 7252.3);
INSERT INTO "transactions_account" VALUES (36, 'sample', 1, 2, 2, 34, null, null, 150.0, '2017-08-16', null, null, 'Y', 'N', null, null, null, 4937.9, 7402.3);
INSERT INTO "transactions_account" VALUES (37, 'sample', 2, 1, 133, null, 1, 0.0, 18.4442662389735, '2017-08-16', null, '', 'Y', 'N', '', 1, 1, 2464.4, 7252.3);
INSERT INTO "transactions_account" VALUES (38, 'sample', 2, 3, 3, 37, null, null, 115.0, '2017-08-16', null, null, 'Y', 'N', null, null, null, 2464.4, 7252.3);
INSERT INTO "transactions_account" VALUES (39, 'sample', 1, 2, 2, 37, null, null, 115.0, '2017-08-16', null, null, 'Y', 'N', null, null, null, 5052.9, 1275.10825982358);
INSERT INTO "transactions_account" VALUES (40, 'sample', 1, 3, 34, null, null, 0.0, 168.0, '2017-08-16', null, '', 'Y', 'N', '', 1, 1, 4787.9, 7367.3);
INSERT INTO "transactions_account" VALUES (41, 'sample', 1, 3, 37, null, null, 0.0, 113.0, '2017-08-18', null, '', 'Y', '', '', 1, 1, 4939.9, 1256.98476343224);
INSERT INTO "transactions_account" VALUES (42, 'sample', 1, 3, 100, null, null, 0.0, 12.0, '2017-08-21', null, '', 'Y', 'N', '', 1, 1, 4927.9, 7825.3);
INSERT INTO "transactions_account" VALUES (43, 'sample', 1, 3, 34, null, null, 0.0, 87.0, '2017-08-21', null, '', 'Y', 'N', '', 1, 1, 4840.9, 7650.3);
INSERT INTO "transactions_account" VALUES (44, 'sample', 2, 2, 7, null, null, 0.0, 34.0016038492382, '2017-08-21', null, '', 'Y', 'N', '', 1, 0, 450.585404971933, 7737.3);
INSERT INTO "transactions_account" VALUES (45, 'sample', 2, 2, 6, null, null, 0.0, 522.0, '2017-08-24', null, '', 'Y', 'N', '', 1, 1, 3331.4, 8172.3);
INSERT INTO "transactions_account" VALUES (46, 'sample', 2, 3, 32, null, null, 0.0, 266.0, '2017-01-07', null, '', 'Y', 'N', '', 1, 1, 15676.0, 17113.0);
INSERT INTO "transactions_account" VALUES (47, 'sample', 1, 2, 10, null, null, 0.0, 187.0, '2017-01-07', null, '', 'Y', 'N', '', 1, 1, 1624.0, 17300.0);
INSERT INTO "transactions_account" VALUES (48, 'sample', 2, 1, 133, null, 1, 0.0, 230.0, '2017-01-07', null, '', 'Y', 'N', '', 1, 1, 16591.0, 18445.0);
INSERT INTO "transactions_account" VALUES (49, 'sample', 2, 3, 3, 48, null, null, 230.0, '2017-01-07', null, '', 'Y', '', null, null, null, 15216.0, 17070.0);
INSERT INTO "transactions_account" VALUES (50, 'sample', 1, 2, 2, 48, null, null, 230.0, '2017-01-07', null, '', 'Y', 'N', null, null, null, 2084.0, 17300.0);
INSERT INTO "transactions_account" VALUES (51, 'sample', 1, 1, 134, null, 2, 0.0, 300.0, '2017-01-07', null, '', 'Y', 'N', '', 1, 1, 1854.0, 18445.0);
INSERT INTO "transactions_account" VALUES (52, 'sample', 1, 3, 3, 51, null, null, 48.1154771451484, '2017-01-07', null, '', 'Y', 'N', null, null, null, 1784.0, 17000.0);
INSERT INTO "transactions_account" VALUES (53, 'sample', 2, 2, 2, 51, null, null, 300.0, '2017-01-07', null, '', 'Y', 'N', null, null, null, 15942.0, 17379.0);
INSERT INTO "transactions_account" VALUES (54, 'sample', 2, 3, 32, null, null, 0.0, 90.0, '2017-01-08', null, '', 'Y', 'Y', '', 1, 4, 14984.0, 16768.0);
INSERT INTO "transactions_account" VALUES (55, 'sample', 2, 3, 32, 54, null, null, 14.4346431435445, '2017-02-08', null, '', 'Y', 'Y', 'M', 2, 1, 257.0, 1988.0);
INSERT INTO "transactions_account" VALUES (56, 'sample', 2, 3, 32, 54, null, null, 90.0, '2017-03-08', null, '', 'Y', 'Y', 'M', 3, 4, 3297.5, 4942.4);
INSERT INTO "transactions_account" VALUES (57, 'sample', 2, 3, 32, 54, null, null, 90.0, '2017-04-08', null, '', 'Y', 'Y', 'M', 1, 4, 4579.3, 6015.2);
INSERT INTO "transactions_account" VALUES (58, 'sample', 1, 3, 34, null, null, 0.0, 11.0, '2017-01-09', null, '', '', 'N', '', 1, 0, 1773.0, 16757.0);
INSERT INTO "transactions_account" VALUES (59, 'sample', 2, 2, 13, null, null, 0.0, 84.6832397754611, '2017-01-16', null, '', 'Y', 'N', '', 1, 1, -2753.0, -829.0);
INSERT INTO "transactions_account" VALUES (60, 'sample', 2, 1, 133, null, 1, 0.0, 150.0, '2017-01-16', null, '', 'Y', 'N', '', 1, 1, -3281.0, -1507.0);
INSERT INTO "transactions_account" VALUES (61, 'sample', 2, 3, 3, 60, null, null, 150.0, '2017-01-16', null, null, 'Y', 'N', null, null, null, -526.222935044106, -1393.0);
INSERT INTO "transactions_account" VALUES (62, 'sample', 1, 2, 2, 60, null, null, 150.0, '2017-01-16', null, null, 'Y', '', null, null, null, 308.580593424218, -1357.0);
INSERT INTO "transactions_account" VALUES (63, 'sample', 2, 1, 133, null, 1, 0.0, 18.4442662389735, '2017-01-16', null, '', 'Y', 'N', '', 1, 1, -3016.0, -1243.0);
INSERT INTO "transactions_account" VALUES (64, 'sample', 2, 3, 3, 63, null, null, 115.0, '2017-01-16', null, null, 'Y', 'N', null, null, null, -3131.0, -1358.0);
INSERT INTO "transactions_account" VALUES (65, 'sample', 1, 2, 2, 63, null, null, 115.0, '2017-01-16', null, null, 'Y', 'N', null, null, null, 1888.0, -1243.0);
INSERT INTO "transactions_account" VALUES (66, 'sample', 1, 3, 34, null, null, 0.0, 114.0, '2017-01-16', null, '', 'Y', 'N', '', 0, 1, 284.522854851644, -1507.0);
INSERT INTO "transactions_account" VALUES (67, 'sample', 1, 3, 37, null, null, 0.0, 55.5, '2017-01-18', null, '', 'Y', 'N', '', 1, 1, 1868.5, -884.5);
INSERT INTO "transactions_account" VALUES (68, 'sample', 1, 3, 100, null, null, 0.0, 54.0, '2017-01-21', null, '', 'Y', '', '', 1, 1, 1814.5, -1238.5);
INSERT INTO "transactions_account" VALUES (69, 'sample', 1, 3, 34, null, null, 0.0, 54.0, '2017-01-21', null, '', 'Y', 'N', '', 1, 1, 1760.5, -1178.5);
INSERT INTO "transactions_account" VALUES (70, 'sample', 2, 2, 7, null, null, 0.0, 114.0, '2017-01-21', null, '', 'Y', 'N', '', 1, 1, -2939.0, -1124.5);
INSERT INTO "transactions_account" VALUES (71, 'sample', 2, 2, 6, null, null, 0.0, 547.0, '2017-01-24', null, '', 'Y', 'N', '', 1, 1, -2392.0, -631.5);
INSERT INTO "transactions_account" VALUES (72, 'sample', 2, 3, 32, null, null, 0.0, 331.0, '2017-02-07', null, '', '', 'N', '', 1, 1, 47.0, 1848.0);
INSERT INTO "transactions_account" VALUES (73, 'sample', 1, 2, 10, null, null, 0.0, 40.5, '2017-02-07', null, '', 'Y', 'N', '', 1, 1, 1801.0, 2409.0);
INSERT INTO "transactions_account" VALUES (74, 'sample', 2, 1, 133, null, 1, 0.0, 230.0, '2017-02-07', null, '', 'Y', 'N', '', 1, 1, 378.0, 2179.0);
INSERT INTO "transactions_account" VALUES (75, 'sample', 2, 3, 3, 74, null, null, 36.8885324779471, '2017-02-07', null, '', 'Y', 'N', null, null, null, 378.0, 2179.0);
INSERT INTO "transactions_account" VALUES (76, 'sample', 1, 2, 2, 74, null, null, 230.0, '2017-02-07', null, '', 'Y', 'N', null, null, null, 2031.0, 2078.0);
INSERT INTO "transactions_account" VALUES (77, 'sample', 1, 1, 134, null, 2, 0.0, 300.0, '2017-02-07', null, '', '', 'N', '', 1, 1, 1801.0, 2409.0);
INSERT INTO "transactions_account" VALUES (78, 'sample', 1, 3, 3, 77, null, null, 300.0, '2017-02-07', null, '', '', '', null, null, null, 1731.0, 2078.0);
INSERT INTO "transactions_account" VALUES (79, 'sample', 2, 2, 2, 77, null, null, 300.0, '2017-02-07', null, '', 'Y', 'N', null, null, null, 347.0, 2378.0);
INSERT INTO "transactions_account" VALUES (80, 'sample', 2, 3, 32, null, null, 0.0, 16.5677626303128, '2017-02-08', null, '', 'Y', 'Y', 'M', 0, 1, 153.7, 1884.7);
INSERT INTO "transactions_account" VALUES (81, 'sample', 2, 3, 32, 80, null, null, 103.3, '2017-03-08', null, '', '', '', 'M', 2, 1, 3387.5, 5032.4);
INSERT INTO "transactions_account" VALUES (82, 'sample', 2, 3, 32, 80, null, null, 103.3, '2017-04-08', null, '', 'Y', 'Y', 'M', 3, 1, 4476.0, 5911.9);
INSERT INTO "transactions_account" VALUES (83, 'sample', 2, 3, 32, 80, null, null, 103.3, '2017-05-08', null, '', 'Y', 'Y', 'M', 4, 4, 8850.7, 10048.6);
INSERT INTO "transactions_account" VALUES (84, 'sample', 1, 3, 34, null, null, 0.0, 103.0, '2017-02-09', null, '', 'Y', 'N', '', 1, 1, 1628.0, 1639.7);
INSERT INTO "transactions_account" VALUES (85, 'sample', 2, 2, 13, null, null, 0.0, 101.523656776263, '2017-02-16', null, '', 'Y', '', '', 1, 1, 644.7, 2387.7);
INSERT INTO "transactions_account" VALUES (86, 'sample', 2, 1, 133, null, 1, 0.0, 24.0577385725742, '2017-02-16', null, '', 'Y', 'N', '', 1, 1, 644.7, 2387.7);
INSERT INTO "transactions_account" VALUES (87, 'sample', 2, 3, 3, 86, null, null, 150.0, '2017-02-16', null, null, 'Y', 'N', null, null, null, 494.7, 345.42101042502);
INSERT INTO "transactions_account" VALUES (88, 'sample', 1, 2, 2, 86, null, null, 150.0, '2017-02-16', null, null, 'Y', 'N', null, null, null, 1809.0, 2303.7);
INSERT INTO "transactions_account" VALUES (89, 'sample', 2, 1, 133, null, 1, 0.0, 115.0, '2017-02-16', null, '', 'Y', 'N', '', 1, 0, 11.7, 1639.7);
INSERT INTO "transactions_account" VALUES (90, 'sample', 2, 3, 3, 89, null, null, 115.0, '2017-02-16', null, null, '', 'N', null, null, null, 379.7, 2188.7);
INSERT INTO "transactions_account" VALUES (91, 'sample', 1, 2, 2, 89, null, null, 115.0, '2017-02-16', null, null, 'Y', 'N', null, null, null, 1743.0, 281.427425821973);
INSERT INTO "transactions_account" VALUES (92, 'sample', 1, 3, 34, null, null, 0.0, 84.0, '2017-02-16', null, '', 'Y', 'N', '', 0, 1, 1659.0, 2303.7);
INSERT INTO "transactions_account" VALUES (93, 'sample', 1, 3, 37, null, null, 0.0, 61.0, '2017-02-18', null, '', 'Y', 'N', '', 1, 1, 1748.0, 2127.7);
INSERT INTO "transactions_account" VALUES (94, 'sample', 1, 3, 100, null, null, 0.0, 5.0, '2017-02-21', null, '', 'Y', 'N', '', 1, 0, 1610.0, 2121.7);
INSERT INTO "transactions_account" VALUES (95, 'sample', 1, 3, 34, null, null, 0.0, 133.0, '2017-02-21', null, '', 'Y', 'N', '', 1, 1, 1615.0, 2126.7);
INSERT INTO "transactions_account" VALUES (96, 'sample', 2, 2, 7, null, null, 0.0, 132.0, '2017-02-21', null, '', 'Y', 'N', '', 1, 0, 511.7, 2259.7);
INSERT INTO "transactions_account" VALUES (97, 'sample', 2, 2, 6, null, null, 0.0, 494.0, '2017-02-24', null, '', 'Y', 'N', '', 1, 0, 705.7, 2315.7);
INSERT INTO "transactions_account" VALUES (98, 'sample', 2, 3, 32, null, null, 0.0, 249.0, '2017-03-07', null, '', 'Y', '', '', 1, 1, 3526.8, 5171.7);
INSERT INTO "transactions_account" VALUES (99, 'sample', 1, 2, 10, null, null, 0.0, 105.0, '2017-03-07', null, '', 'Y', 'N', '', 1, 1, 1644.9, 5420.7);
INSERT INTO "transactions_account" VALUES (100, 'sample', 2, 1, 133, null, 1, 0.0, 36.8724939855654, '2017-03-07', null, '', 'Y', 'N', '', 1, 1, 3775.8, 5420.7);
INSERT INTO "transactions_account" VALUES (101, 'sample', 2, 3, 3, 100, null, null, 36.8724939855654, '2017-03-07', null, '', 'Y', 'N', null, null, null, 3775.8, 5315.7);
INSERT INTO "transactions_account" VALUES (102, 'sample', 1, 2, 2, 100, null, null, 229.9, '2017-03-07', null, '', 'Y', 'N', null, null, null, 1539.9, 5545.6);
INSERT INTO "transactions_account" VALUES (103, 'sample', 1, 1, 134, null, 2, 0.0, 300.0, '2017-03-07', null, '', 'Y', 'N', '', 1, 0, 1539.9, 5315.7);
INSERT INTO "transactions_account" VALUES (104, 'sample', 1, 3, 3, 103, null, null, 300.0, '2017-03-07', null, '', 'Y', 'N', null, null, null, 1310.0, 5015.7);
INSERT INTO "transactions_account" VALUES (105, 'sample', 2, 2, 2, 103, null, null, 300.0, '2017-03-07', null, '', '', 'N', null, null, null, 4005.7, 5315.7);
INSERT INTO "transactions_account" VALUES (106, 'sample', 2, 3, 32, null, null, 0.0, 129.9, '2017-03-08', null, '', 'Y', 'Y', 'M', 1, 4, 3121.6, 764.474739374499);
INSERT INTO "transactions_account" VALUES (107, 'sample', 2, 3, 32, 106, null, null, 129.9, '2017-04-08', null, '', 'N', 'Y', '', 2, 4, 6773.0, 8479.0);
INSERT INTO "transactions_account" VALUES (108, 'sample', 2, 3, 32, 106, null, null, 129.9, '2017-05-08', null, '', '', 'Y', 'M', 3, 4, 8720.8, 9918.7);
INSERT INTO "transactions_account" VALUES (109, 'sample', 2, 3, 32, 106, null, null, 20.8340016038492, '2017-06-08', null, '', 'Y', '', 'M', 4, 4, 6925.4, 7662.3);
INSERT INTO "transactions_account" VALUES (110, 'sample', 1, 3, 34, null, null, 0.0, 14.0, '2017-03-09', null, '', 'Y', 'N', '', 1, 1, 1630.9, 4752.5);
INSERT INTO "transactions_account" VALUES (111, 'sample', 2, 2, 13, null, null, 0.0, 454.0, '2017-03-16', null, '', 'Y', '', '', 1, 1, 1960.6, 3591.5);
INSERT INTO "transactions_account" VALUES (112, 'sample', 2, 1, 133, null, 0, 0.0, 150.0, '2017-03-16', null, '', 'Y', 'N', '', 1, 1, 1960.6, 3591.5);
INSERT INTO "transactions_account" VALUES (113, 'sample', 2, 3, 3, 112, null, null, 150.0, '2017-03-16', null, null, 'Y', 'N', null, null, null, 1810.6, 3441.5);
INSERT INTO "transactions_account" VALUES (114, 'sample', 1, 2, 2, 112, null, null, 150.0, '2017-03-16', null, null, 'Y', 'N', null, null, null, 1780.9, 3591.5);
INSERT INTO "transactions_account" VALUES (115, 'sample', 2, 1, 133, null, 1, 0.0, 115.0, '2017-03-16', null, '', '', 'N', '', 1, 1, 1810.6, 3591.5);
INSERT INTO "transactions_account" VALUES (116, 'sample', 2, 3, 3, 115, null, null, 115.0, '2017-03-16', null, null, 'Y', 'N', null, null, null, 1506.6, 503.207698476343);
INSERT INTO "transactions_account" VALUES (117, 'sample', 1, 2, 2, 115, null, null, 115.0, '2017-03-16', null, null, 'Y', 'N', null, null, null, 1707.9, 3518.5);
INSERT INTO "transactions_account" VALUES (118, 'sample', 1, 3, 34, null, null, 0.0, 188.0, '2017-03-16', null, '', 'Y', 'N', '', 1, 1, 1592.9, 3403.5);
INSERT INTO "transactions_account" VALUES (119, 'sample', 1, 3, 37, null, null, 0.0, 24.85966319166, '2017-03-18', null, '', 'Y', 'N', '', 1, 1, 1552.9, 3363.5);
INSERT INTO "transactions_account" VALUES (120, 'sample', 1, 3, 100, null, null, 0.0, 36.0, '2017-03-21', null, '', 'Y', 'N', '', 1, 1, 1448.9, 3099.5);
INSERT INTO "transactions_account" VALUES (121, 'sample', 1, 3, 34, null, null, 0.0, 68.0, '2017-03-21', null, '', 'Y', 'N', '', 1, 1, 1484.9, 2995.5);
INSERT INTO "transactions_account" VALUES (122, 'sample', 2, 2, 7, null, null, 0.0, 140.0, '2017-03-21', null, '', 'Y', 'N', '', 1, 1, 1650.6, 3135.5);
INSERT INTO "transactions_account" VALUES (123, 'sample', 2, 2, 6, null, null, 0.0, 533.0, '2017-03-24', null, '', 'Y', 'N', '', 1, 1, 2183.6, 3632.5);
INSERT INTO "transactions_account" VALUES (124, 'sample', 2, 3, 32, null, null, 0.0, 215.0, '2017-04-07', null, '', '', '', '', 1, 0, 4772.6, 6188.5);
INSERT INTO "transactions_account" VALUES (125, 'sample', 1, 2, 10, null, null, 0.0, 20.0, '2017-04-07', null, '', 'Y', 'N', '', 1, 0, 1435.9, 6208.5);
INSERT INTO "transactions_account" VALUES (126, 'sample', 2, 1, 133, null, 1, 0.0, 230.0, '2017-04-07', null, '', 'Y', 'N', '', 1, 1, 4772.6, 6188.5);
INSERT INTO "transactions_account" VALUES (127, 'sample', 2, 3, 3, 126, null, null, 230.0, '2017-04-07', null, '', '', 'N', null, null, null, 4687.6, 6173.5);
INSERT INTO "transactions_account" VALUES (128, 'sample', 1, 2, 2, 126, null, null, 230.0, '2017-04-07', null, '', 'Y', 'N', null, null, null, 1415.9, 6403.5);
INSERT INTO "transactions_account" VALUES (129, 'sample', 1, 1, 134, null, 2, 0.0, 300.0, '2017-04-07', null, '', 'Y', 'N', '', 1, 0, 190.200481154771, 6173.5);
INSERT INTO "transactions_account" VALUES (130, 'sample', 1, 3, 3, 129, null, null, 300.0, '2017-04-07', null, '', '', 'N', null, null, null, 1185.9, 6173.5);
INSERT INTO "transactions_account" VALUES (131, 'sample', 2, 2, 2, 129, null, null, 300.0, '2017-04-07', null, '', 'Y', 'N', null, null, null, 4987.6, 6473.5);
INSERT INTO "transactions_account" VALUES (132, 'sample', 2, 3, 32, null, null, 0.0, 31.2750601443464, '2017-04-08', null, '', 'Y', 'Y', 'M', 1, 1, 678.267842822775, 5664.9);
INSERT INTO "transactions_account" VALUES (133, 'sample', 2, 3, 32, 132, null, null, 195.0, '2017-05-08', null, '', 'Y', 'Y', 'M', 2, 4, 8525.8, 9723.7);
INSERT INTO "transactions_account" VALUES (134, 'sample', 2, 3, 32, 132, null, null, 195.0, '2017-06-08', null, '', 'N', 'Y', 'M', 3, 1, 7055.3, 7792.2);
INSERT INTO "transactions_account" VALUES (135, 'sample', 2, 3, 32, 132, null, null, 195.0, '2017-07-08', null, '', 'N', 'Y', 'M', 4, 1, 8921.4, 11574.3);
INSERT INTO "transactions_account" VALUES (136, 'sample', 1, 3, 34, null, null, 0.0, 135.0, '2017-04-09', null, '', 'Y', 'N', '', 1, 1, 1249.9, 5432.9);
INSERT INTO "transactions_account" VALUES (137, 'sample', 2, 2, 13, null, null, 0.0, 603.0, '2017-04-16', null, '', 'Y', 'N', '', 1, 1, 4786.0, 5894.9);
INSERT INTO "transactions_account" VALUES (138, 'sample', 2, 1, 133, null, 1, 0.0, 150.0, '2017-04-16', null, '', 'Y', 'N', '', 1, 1, 4786.0, 5894.9);
INSERT INTO "transactions_account" VALUES (139, 'sample', 2, 3, 3, 138, null, null, 150.0, '2017-04-16', null, null, 'Y', 'N', null, null, null, 743.544506816359, 5744.9);
INSERT INTO "transactions_account" VALUES (140, 'sample', 1, 2, 2, 138, null, null, 150.0, '2017-04-16', null, null, 'Y', 'N', null, null, null, 201.908580593424, 5894.9);
INSERT INTO "transactions_account" VALUES (141, 'sample', 2, 1, 133, null, 1, 0.0, 115.0, '2017-04-16', null, '', 'Y', 'N', '', 1, 1, 4521.0, 5779.9);
INSERT INTO "transactions_account" VALUES (142, 'sample', 2, 3, 3, 141, null, null, 115.0, '2017-04-16', null, null, 'Y', 'N', null, null, null, 4521.0, 5779.9);
INSERT INTO "transactions_account" VALUES (143, 'sample', 1, 2, 2, 141, null, null, 115.0, '2017-04-16', null, null, 'Y', 'N', null, null, null, 1373.9, 5894.9);
INSERT INTO "transactions_account" VALUES (144, 'sample', 1, 3, 34, null, null, 0.0, 141.0, '2017-04-16', null, '', 'Y', 'N', '', 1, 1, 1108.9, 5291.9);
INSERT INTO "transactions_account" VALUES (145, 'sample', 1, 3, 37, null, null, 0.0, 23.0, '2017-04-18', null, '', 'Y', 'N', '', 1, 1, 1539.9, 1009.28628708901);
INSERT INTO "transactions_account" VALUES (146, 'sample', 1, 3, 100, null, null, 0.0, 141.0, '2017-04-21', null, '', 'Y', 'N', '', 1, 1, 1212.9, 5665.9);
INSERT INTO "transactions_account" VALUES (147, 'sample', 1, 3, 34, null, null, 0.0, 23.5765838011227, '2017-04-21', null, '', 'Y', '', '', 1, 1, 1353.9, 5806.9);
INSERT INTO "transactions_account" VALUES (148, 'sample', 2, 2, 7, null, null, 0.0, 91.0, '2017-04-21', null, '', 'Y', 'N', '', 1, 1, 4544.0, 5756.9);
INSERT INTO "transactions_account" VALUES (149, 'sample', 2, 2, 6, null, null, 0.0, 590.0, '2017-04-24', null, '', 'Y', '', '', 1, 1, 6054.0, 7200.9);
INSERT INTO "transactions_account" VALUES (150, 'sample', 2, 3, 32, null, null, 0.0, 53.8893344025662, '2017-04-07', null, '', '', 'N', '', 1, 1, 4917.6, 1027.02485966319);
INSERT INTO "transactions_account" VALUES (151, 'sample', 1, 2, 10, null, null, 0.0, 107.0, '2017-04-07', null, '', 'Y', '', '', 1, 1, 1785.9, 6739.5);
INSERT INTO "transactions_account" VALUES (152, 'sample', 2, 1, 133, null, 1, 0.0, 230.0, '2017-04-07', null, '', 'Y', 'N', '', 1, 1, 4917.6, 6403.5);
INSERT INTO "transactions_account" VALUES (153, 'sample', 2, 3, 3, 152, null, null, 230.0, '2017-04-07', null, '', 'Y', 'N', null, null, null, 4953.6, 6402.5);
INSERT INTO "transactions_account" VALUES (154, 'sample', 1, 2, 2, 152, null, null, 230.0, '2017-04-07', null, '', 'Y', '', null, null, null, 1678.9, 6632.5);
INSERT INTO "transactions_account" VALUES (155, 'sample', 1, 1, 134, null, 2, 0.0, 300.0, '2017-04-07', null, '', 'Y', 'N', '', 1, 1, 1678.9, 6632.5);
INSERT INTO "transactions_account" VALUES (156, 'sample', 1, 3, 3, 155, null, null, 300.0, '2017-04-07', null, '', 'Y', '', null, null, null, 1485.9, 6439.5);
INSERT INTO "transactions_account" VALUES (157, 'sample', 2, 2, 2, 155, null, null, 300.0, '2017-04-07', null, '', 'Y', 'N', null, null, null, 5253.6, 6739.5);
INSERT INTO "transactions_account" VALUES (158, 'sample', 2, 3, 32, null, null, 0.0, 52.0, '2017-04-08', null, '', 'Y', 'Y', 'M', 1, 4, 4424.0, 5859.9);
INSERT INTO "transactions_account" VALUES (159, 'sample', 2, 3, 32, 158, null, null, 52.0, '2017-05-08', null, '', '', 'Y', 'M', 2, 4, 8473.8, 9671.7);
INSERT INTO "transactions_account" VALUES (160, 'sample', 2, 3, 32, 158, null, null, 52.0, '2017-06-08', null, '', '', 'Y', 'M', 3, 4, 7055.3, 7792.2);
INSERT INTO "transactions_account" VALUES (161, 'sample', 2, 3, 32, 158, null, null, 52.0, '2017-07-08', null, '', 'N', 'Y', 'M', 4, 4, 8921.4, 11574.3);
INSERT INTO "transactions_account" VALUES (162, 'sample', 1, 3, 34, null, null, 0.0, 51.0, '2017-04-09', null, '', 'Y', 'N', '', 1, 1, 1384.9, 5567.9);
INSERT INTO "transactions_account" VALUES (163, 'sample', 2, 2, 13, null, null, 0.0, 497.0, '2017-04-16', null, '', 'Y', 'N', '', 1, 1, 780.753809141941, 6506.9);
INSERT INTO "transactions_account" VALUES (164, 'sample', 2, 1, 133, null, 0, 0.0, 150.0, '2017-04-16', null, '', 'Y', 'N', '', 1, 1, 4371.0, 5859.9);
INSERT INTO "transactions_account" VALUES (165, 'sample', 2, 3, 3, 164, null, null, 150.0, '2017-04-16', null, null, 'Y', 'N', null, null, null, 4371.0, 5744.9);
INSERT INTO "transactions_account" VALUES (166, 'sample', 1, 2, 2, 164, null, null, 150.0, '2017-04-16', null, null, 'Y', 'N', null, null, null, 1638.9, 6009.9);
INSERT INTO "transactions_account" VALUES (167, 'sample', 2, 1, 133, null, 1, 0.0, 115.0, '2017-04-16', null, '', 'Y', 'N', '', 1, 1, 701.042502004812, 5859.9);
INSERT INTO "transactions_account" VALUES (168, 'sample', 2, 3, 3, 167, null, null, 115.0, '2017-04-16', null, null, 'Y', 'N', null, null, null, 762.309542902967, 6391.9);
INSERT INTO "transactions_account" VALUES (169, 'sample', 1, 2, 2, 167, null, null, 115.0, '2017-04-16', null, null, 'Y', 'N', null, null, null, 1488.9, 5859.9);
INSERT INTO "transactions_account" VALUES (170, 'sample', 1, 3, 34, null, null, 0.0, 76.0, '2017-04-16', null, '', 'Y', 'N', '', 1, 1, 1562.9, 6315.9);
INSERT INTO "transactions_account" VALUES (171, 'sample', 1, 3, 37, null, null, 0.0, 39.0, '2017-04-18', null, '', 'Y', 'N', '', 1, 1, 1500.9, 6253.9);
INSERT INTO "transactions_account" VALUES (172, 'sample', 1, 3, 100, null, null, 0.0, 32.0, '2017-04-21', null, '', 'Y', 'N', '', 1, 1, 1180.9, 5724.9);
INSERT INTO "transactions_account" VALUES (173, 'sample', 1, 3, 34, null, null, 0.0, 34.0, '2017-04-21', null, '', 'Y', 'N', '', 1, 1, 1146.9, 5690.9);
INSERT INTO "transactions_account" VALUES (174, 'sample', 2, 2, 7, null, null, 0.0, 327.0, '2017-04-21', null, '', 'Y', 'N', '', 1, 1, 4871.0, 6017.9);
INSERT INTO "transactions_account" VALUES (175, 'sample', 2, 2, 6, null, null, 0.0, 593.0, '2017-04-24', null, '', 'Y', 'N', '', 1, 1, 5464.0, 6610.9);
INSERT INTO "transactions_account" VALUES (176, 'sample', 2, 3, 32, null, null, 0.0, 27.2654370489174, '2017-05-07', null, '', 'Y', 'N', '', 1, 1, 8654.0, 9500.9);
INSERT INTO "transactions_account" VALUES (177, 'sample', 1, 2, 10, null, null, 0.0, 121.0, '2017-05-07', null, '', 'Y', 'N', '', 1, 1, 967.9, 9621.9);
INSERT INTO "transactions_account" VALUES (178, 'sample', 2, 1, 133, null, 1, 0.0, 230.0, '2017-05-07', null, '', 'Y', 'N', '', 1, 1, 8654.0, 9500.9);
INSERT INTO "transactions_account" VALUES (179, 'sample', 2, 3, 3, 178, null, null, 230.0, '2017-05-07', null, '', 'Y', 'N', null, null, null, 8824.0, 9670.9);
INSERT INTO "transactions_account" VALUES (180, 'sample', 1, 2, 2, 178, null, null, 230.0, '2017-05-07', null, '', 'Y', 'N', null, null, null, 192.125100240577, 10151.9);
INSERT INTO "transactions_account" VALUES (181, 'sample', 1, 1, 134, null, 2, 0.0, 300.0, '2017-05-07', null, '', 'Y', 'N', '', 1, 1, 135.829991980754, 9500.9);
INSERT INTO "transactions_account" VALUES (182, 'sample', 1, 3, 3, 181, null, null, 300.0, '2017-05-07', null, '', 'Y', 'N', null, null, null, 846.9, 9900.9);
INSERT INTO "transactions_account" VALUES (183, 'sample', 2, 2, 2, 181, null, null, 300.0, '2017-05-07', null, '', 'Y', 'N', null, null, null, 8954.0, 9921.9);
INSERT INTO "transactions_account" VALUES (184, 'sample', 2, 3, 32, null, null, 0.0, 45.5, '2017-05-08', null, '', 'Y', 'Y', 'M', 1, 4, 8428.3, 9626.2);
INSERT INTO "transactions_account" VALUES (185, 'sample', 2, 3, 32, 184, null, null, 45.5, '2017-06-08', null, '', 'N', 'Y', 'M', 2, 4, 7055.3, 7792.2);
INSERT INTO "transactions_account" VALUES (186, 'sample', 2, 3, 32, 184, null, null, 45.5, '2017-07-08', null, '', 'N', 'Y', 'M', 3, 4, 8921.4, 11574.3);
INSERT INTO "transactions_account" VALUES (187, 'sample', 2, 3, 32, 184, null, null, 45.5, '2017-08-08', null, '', 'N', 'Y', 'M', 4, 4, 2579.4, 7568.3);
INSERT INTO "transactions_account" VALUES (188, 'sample', 1, 3, 34, null, null, 0.0, 118.0, '2017-05-09', null, '', 'Y', 'N', '', 1, 1, 1079.9, 9508.2);
INSERT INTO "transactions_account" VALUES (189, 'sample', 2, 2, 13, null, null, 0.0, 605.0, '2017-05-16', null, '', 'Y', '', '', 1, 1, 8768.3, 10113.2);
INSERT INTO "transactions_account" VALUES (190, 'sample', 2, 1, 133, null, 1, 0.0, 150.0, '2017-05-16', null, '', 'Y', 'N', '', 1, 1, 8163.3, 1524.97193263833);
INSERT INTO "transactions_account" VALUES (191, 'sample', 2, 3, 3, 190, null, null, 150.0, '2017-05-16', null, null, 'Y', 'N', null, null, null, 8163.3, 9508.2);
INSERT INTO "transactions_account" VALUES (192, 'sample', 1, 2, 2, 190, null, null, 150.0, '2017-05-16', null, null, 'Y', 'N', null, null, null, 1344.9, 9658.2);
INSERT INTO "transactions_account" VALUES (193, 'sample', 2, 1, 133, null, 1, 0.0, 115.0, '2017-05-16', null, '', 'Y', 'N', '', 0, 1, 1333.32798716921, 9508.2);
INSERT INTO "transactions_account" VALUES (194, 'sample', 2, 3, 3, 193, null, null, 115.0, '2017-05-16', null, null, 'Y', 'N', null, null, null, 8313.3, 9508.2);
INSERT INTO "transactions_account" VALUES (195, 'sample', 1, 2, 2, 193, null, null, 115.0, '2017-05-16', null, null, 'Y', 'N', null, null, null, 1194.9, 9623.2);
INSERT INTO "transactions_account" VALUES (196, 'sample', 1, 3, 34, null, null, 0.0, 112.0, '2017-05-16', null, '', 'Y', 'N', '', 1, 1, 1232.9, 10001.2);
INSERT INTO "transactions_account" VALUES (197, 'sample', 1, 3, 37, null, null, 0.0, 60.0, '2017-05-18', null, '', 'Y', 'N', '', 1, 1, 1172.9, 9941.2);
INSERT INTO "transactions_account" VALUES (198, 'sample', 1, 3, 100, null, null, 0.0, 109.0, '2017-05-21', null, '', 'Y', 'N', '', 1, 0, 1055.9, 9757.2);
INSERT INTO "transactions_account" VALUES (199, 'sample', 1, 3, 34, null, null, 0.0, 8.0, '2017-05-21', null, '', 'Y', 'N', '', 1, 1, 1164.9, 9933.2);
INSERT INTO "transactions_account" VALUES (200, 'sample', 2, 2, 7, null, null, 0.0, 233.0, '2017-05-21', null, '', 'Y', 'N', '', 1, 1, 9001.3, 10166.2);
INSERT INTO "transactions_account" VALUES (201, 'sample', 2, 2, 6, null, null, 0.0, 87.2493985565357, '2017-05-24', null, '', 'Y', 'N', '', 1, 1, 9245.3, 10301.2);
INSERT INTO "transactions_account" VALUES (202, 'sample', 2, 3, 32, null, null, 0.0, 183.0, '2017-06-07', null, '', 'Y', 'N', '', 1, 1, 7355.3, 8284.2);
INSERT INTO "transactions_account" VALUES (203, 'sample', 1, 2, 10, null, null, 0.0, 108.0, '2017-06-07', null, '', 'Y', 'N', '', 1, 1, 736.9, 1297.86688051323);
INSERT INTO "transactions_account" VALUES (207, 'sample', 1, 1, 134, null, 0, 0.0, 300.0, '2017-06-07', null, '', 'Y', 'N', '', 1, 1, 928.9, 8284.2);
INSERT INTO "transactions_account" VALUES (208, 'sample', 1, 3, 3, 207, null, null, 300.0, '2017-06-07', null, '', '', 'N', null, null, null, 628.9, 7984.2);
INSERT INTO "transactions_account" VALUES (209, 'sample', 2, 2, 2, 207, null, null, 300.0, '2017-06-07', null, '', 'Y', 'N', null, null, null, 7538.3, 8467.2);
INSERT INTO "transactions_account" VALUES (210, 'sample', 2, 3, 32, null, null, 0.0, 46.0, '2017-01-08', null, '', 'Y', 'Y', 'M', 1, 4, 15170.0, 16954.0);
INSERT INTO "transactions_account" VALUES (211, 'sample', 2, 3, 32, 210, null, null, 46.0, '2017-02-08', null, '', 'Y', 'Y', 'M', 2, 4, 11.7, 1742.7);
INSERT INTO "transactions_account" VALUES (212, 'sample', 2, 3, 32, 210, null, null, 46.0, '2017-03-08', null, '', 'Y', 'Y', 'M', 3, 4, 3251.5, 4896.4);
INSERT INTO "transactions_account" VALUES (213, 'sample', 2, 3, 32, 210, null, null, 46.0, '2017-04-08', null, '', 'Y', 'Y', '', 4, 4, 4183.0, 5618.9);
INSERT INTO "transactions_account" VALUES (214, 'sample', 1, 3, 34, null, null, 0.0, 24.0, '2017-06-09', null, '', '', 'N', '', 1, 0, 712.9, 7638.3);
INSERT INTO "transactions_account" VALUES (215, 'sample', 2, 2, 13, null, null, 0.0, 434.0, '2017-06-16', null, '', 'Y', 'N', '', 1, 1, 7573.4, 8625.3);
INSERT INTO "transactions_account" VALUES (216, 'sample', 2, 1, 133, null, 1, 0.0, 150.0, '2017-06-16', null, '', 'Y', 'N', '', 0, 0, 7573.4, 8625.3);
INSERT INTO "transactions_account" VALUES (217, 'sample', 2, 3, 3, 216, null, null, 24.0577385725742, '2017-06-16', null, null, 'Y', 'N', null, null, null, 7423.4, 1359.31034482759);
INSERT INTO "transactions_account" VALUES (218, 'sample', 1, 2, 2, 216, null, null, 150.0, '2017-06-16', null, null, 'Y', 'N', null, null, null, 1201.9, 8625.3);
INSERT INTO "transactions_account" VALUES (219, 'sample', 2, 1, 133, null, 1, 0.0, 115.0, '2017-06-16', null, '', 'Y', '', '', 1, 1, 7423.4, 8625.3);
INSERT INTO "transactions_account" VALUES (220, 'sample', 2, 3, 3, 219, null, null, 115.0, '2017-06-16', null, null, 'Y', '', null, null, null, 7308.4, 8510.3);
INSERT INTO "transactions_account" VALUES (221, 'sample', 1, 2, 2, 219, null, null, 115.0, '2017-06-16', null, null, '', 'N', null, null, null, 168.708901363272, 8191.3);
INSERT INTO "transactions_account" VALUES (222, 'sample', 1, 3, 34, null, null, 0.0, 19.0858059342422, '2017-06-16', null, '', 'Y', 'N', '', 1, 1, 1082.9, 8391.3);
INSERT INTO "transactions_account" VALUES (223, 'sample', 1, 3, 37, null, null, 0.0, 25.0, '2017-06-18', null, '', 'Y', 'N', '', 1, 1, 1057.9, 8366.3);
INSERT INTO "transactions_account" VALUES (224, 'sample', 1, 3, 100, null, null, 0.0, 85.0, '2017-06-21', null, '', 'Y', 'N', '', 1, 0, 575.9, 7948.3);
INSERT INTO "transactions_account" VALUES (225, 'sample', 1, 3, 34, null, null, 0.0, 158.0, '2017-06-21', null, '', 'Y', 'N', '', 1, 1, 660.9, 1288.4202085004);
INSERT INTO "transactions_account" VALUES (226, 'sample', 2, 2, 7, null, null, 0.0, 104.0, '2017-06-21', null, '', '', 'N', '', 1, 1, 7372.4, 8191.3);
INSERT INTO "transactions_account" VALUES (227, 'sample', 2, 2, 6, null, null, 0.0, 531.0, '2017-06-24', null, '', 'Y', 'N', '', 1, 1, 7903.4, 8479.3);
INSERT INTO "transactions_account" VALUES (228, 'sample', 2, 3, 32, null, null, 0.0, 307.0, '2017-06-07', null, '', 'Y', 'N', '', 0, 1, 6938.3, 7994.2);
INSERT INTO "transactions_account" VALUES (229, 'sample', 1, 2, 10, null, null, 0.0, 27.7465918203689, '2017-06-07', null, '', 'Y', '', '', 1, 1, 1228.9, 8167.2);
INSERT INTO "transactions_account" VALUES (233, 'sample', 1, 1, 134, null, 2, 0.0, 300.0, '2017-06-07', null, '', 'Y', 'N', '', 1, 1, 928.9, 8467.2);
INSERT INTO "transactions_account" VALUES (234, 'sample', 1, 3, 3, 233, null, null, 300.0, '2017-06-07', null, '', '', 'N', null, null, null, 928.9, 7867.2);
INSERT INTO "transactions_account" VALUES (235, 'sample', 2, 2, 2, 233, null, null, 300.0, '2017-06-07', null, '', 'Y', 'N', null, null, null, 7238.3, 8167.2);
INSERT INTO "transactions_account" VALUES (236, 'sample', 2, 3, 32, null, null, 0.0, 300.0, '2017-06-08', null, '', 'Y', 'Y', 'M', 1, 4, 7055.3, 7792.2);
INSERT INTO "transactions_account" VALUES (237, 'sample', 2, 3, 32, 236, null, null, 300.0, '2017-07-08', null, '', 'Y', 'Y', 'M', 2, 4, 1430.85805934242, 11574.3);
INSERT INTO "transactions_account" VALUES (238, 'sample', 2, 3, 32, 236, null, null, 48.1154771451484, '2017-08-08', null, '', 'Y', 'Y', 'M', 3, 4, 2579.4, 7568.3);
INSERT INTO "transactions_account" VALUES (239, 'sample', 2, 3, 32, 236, null, null, 300.0, '2017-09-08', null, '', 'N', '', 'M', 4, 4, 6031.4, 7752.3);
INSERT INTO "transactions_account" VALUES (240, 'sample', 1, 3, 34, null, null, 0.0, 22.0, '2017-06-09', null, '', 'Y', 'N', '', 1, 0, 690.9, 1221.53969526864);
INSERT INTO "transactions_account" VALUES (241, 'sample', 2, 2, 13, null, null, 0.0, 479.0, '2017-06-16', null, '', 'Y', 'N', '', 1, 1, 7404.4, 8095.3);
INSERT INTO "transactions_account" VALUES (242, 'sample', 2, 1, 133, null, 1, 0.0, 24.0577385725742, '2017-06-16', null, '', 'Y', 'N', '', 1, 1, 7254.4, 7926.3);
INSERT INTO "transactions_account" VALUES (243, 'sample', 2, 3, 3, 242, null, null, 150.0, '2017-06-16', null, null, 'Y', 'N', null, null, null, 7254.4, 7945.3);
INSERT INTO "transactions_account" VALUES (244, 'sample', 1, 2, 2, 242, null, null, 150.0, '2017-06-16', null, null, '', 'N', null, null, null, 821.9, 7961.3);
INSERT INTO "transactions_account" VALUES (245, 'sample', 2, 1, 133, null, 1, 0.0, 115.0, '2017-06-16', null, '', 'Y', 'N', '', 1, 0, 7139.4, 7811.3);
INSERT INTO "transactions_account" VALUES (246, 'sample', 2, 3, 3, 245, null, null, 115.0, '2017-06-16', null, null, 'Y', 'N', null, null, null, 7139.4, 1252.81475541299);
INSERT INTO "transactions_account" VALUES (247, 'sample', 1, 2, 2, 245, null, null, 115.0, '2017-06-16', null, null, 'Y', 'N', null, null, null, 936.9, 1295.31676022454);
INSERT INTO "transactions_account" VALUES (248, 'sample', 1, 3, 34, null, null, 0.0, 19.0, '2017-06-16', null, '', 'Y', 'N', '', 1, 1, 671.9, 7926.3);
INSERT INTO "transactions_account" VALUES (249, 'sample', 1, 3, 37, null, null, 0.0, 7.0, '2017-06-18', null, '', 'Y', 'N', '', 1, 1, 1050.9, 8359.3);
INSERT INTO "transactions_account" VALUES (250, 'sample', 1, 3, 100, null, null, 0.0, 86.0, '2017-06-21', null, '', 'Y', 'N', '', 1, 1, 131.339214113873, 8387.3);
INSERT INTO "transactions_account" VALUES (251, 'sample', 1, 3, 34, null, null, 0.0, 146.0, '2017-06-21', null, '', 'Y', 'N', '', 1, 1, 904.9, 8213.3);
INSERT INTO "transactions_account" VALUES (252, 'sample', 2, 2, 7, null, null, 0.0, 260.0, '2017-06-21', null, '', 'Y', 'N', '', 1, 0, 7568.4, 8473.3);
INSERT INTO "transactions_account" VALUES (253, 'sample', 2, 2, 6, null, null, 0.0, 513.0, '2017-06-24', null, '', 'Y', 'N', '', 1, 0, 8416.4, 8992.3);
INSERT INTO "transactions_account" VALUES (254, 'sample', 2, 3, 32, null, null, 0.0, 265.0, '2017-07-07', null, '', 'Y', 'N', '', 0, 1, 1467.74659182037, 11727.3);
INSERT INTO "transactions_account" VALUES (255, 'sample', 1, 2, 10, null, null, 0.0, 147.0, '2017-07-07', null, '', 'Y', 'N', '', 1, 1, 2722.9, 11874.3);
INSERT INTO "transactions_account" VALUES (256, 'sample', 2, 1, 133, null, 1, 0.0, 230.0, '2017-07-07', null, '', 'Y', 'N', '', 0, 1, 9221.4, 11874.3);
INSERT INTO "transactions_account" VALUES (257, 'sample', 2, 3, 3, 256, null, null, 230.0, '2017-07-07', null, '', 'Y', 'N', null, null, null, 9221.4, 11874.3);
INSERT INTO "transactions_account" VALUES (258, 'sample', 1, 2, 2, 256, null, null, 230.0, '2017-07-07', null, '', 'Y', 'N', null, null, null, 2652.9, 12104.3);
INSERT INTO "transactions_account" VALUES (259, 'sample', 1, 1, 134, null, 2, 0.0, 300.0, '2017-07-07', null, '', 'Y', 'N', '', 0, 1, 425.485164394547, 11874.3);
INSERT INTO "transactions_account" VALUES (260, 'sample', 1, 3, 3, 259, null, null, 48.1154771451484, '2017-07-07', null, '', 'Y', '', null, null, null, 2422.9, 11874.3);
INSERT INTO "transactions_account" VALUES (261, 'sample', 2, 2, 2, 259, null, null, 300.0, '2017-07-07', null, '', 'Y', 'N', null, null, null, 9451.4, 12174.3);
INSERT INTO "transactions_account" VALUES (262, 'sample', 2, 3, 32, null, null, 0.0, 8.82117080994387, '2017-07-20', null, '', 'Y', 'Y', 'M', 1, 4, 6736.4, 11777.3);
INSERT INTO "transactions_account" VALUES (263, 'sample', 2, 3, 32, 262, null, null, 55.0, '2017-08-20', null, '', 'N', 'Y', 'M', 2, 4, 2897.4, 7837.3);
INSERT INTO "transactions_account" VALUES (264, 'sample', 2, 3, 32, 262, null, null, 55.0, '2017-09-20', null, '', 'N', 'Y', 'M', 3, 1, 6031.4, 7752.3);
INSERT INTO "transactions_account" VALUES (265, 'sample', 2, 3, 32, 262, null, null, 55.0, '2017-10-20', null, '', 'N', 'Y', '', 4, 4, 6031.4, 7752.3);
INSERT INTO "transactions_account" VALUES (266, 'sample', 1, 3, 34, null, null, 0.0, 57.0, '2017-07-09', null, '', '', 'N', '', 1, 1, 416.343223736969, 11517.3);
INSERT INTO "transactions_account" VALUES (267, 'sample', 2, 2, 13, null, null, 0.0, 520.0, '2017-07-16', null, '', 'Y', 'N', '', 1, 1, 1514.25821972735, 12037.3);
INSERT INTO "transactions_account" VALUES (268, 'sample', 2, 1, 133, null, 1, 0.0, 150.0, '2017-07-16', null, '', 'Y', 'N', '', 0, 1, 8921.4, 11517.3);
INSERT INTO "transactions_account" VALUES (269, 'sample', 2, 3, 3, 268, null, null, 150.0, '2017-07-16', null, null, 'Y', 'N', null, null, null, 9291.4, 11856.3);
INSERT INTO "transactions_account" VALUES (270, 'sample', 1, 2, 2, 268, null, null, 150.0, '2017-07-16', null, null, 'Y', 'N', null, null, null, 2745.9, 12187.3);
INSERT INTO "transactions_account" VALUES (274, 'sample', 1, 3, 34, null, null, 0.0, 181.0, '2017-07-16', null, '', 'Y', 'N', '', 1, 1, 2564.9, 12006.3);
INSERT INTO "transactions_account" VALUES (275, 'sample', 1, 3, 37, null, null, 0.0, 3.84923817161187, '2017-07-18', null, '', 'Y', 'N', '', 1, 1, 2540.9, 11832.3);
INSERT INTO "transactions_account" VALUES (276, 'sample', 1, 3, 100, null, null, 0.0, 15.0, '2017-07-21', null, '', 'Y', 'N', '', 1, 1, 4892.9, 11329.3);
INSERT INTO "transactions_account" VALUES (277, 'sample', 1, 3, 34, null, null, 0.0, 133.0, '2017-07-21', null, '', 'Y', 'N', '', 1, 1, 4907.9, 11644.3);
INSERT INTO "transactions_account" VALUES (278, 'sample', 2, 2, 7, null, null, 0.0, 165.0, '2017-07-21', null, '', 'Y', 'N', '', 1, 1, 6601.4, 11494.3);
INSERT INTO "transactions_account" VALUES (279, 'sample', 2, 2, 6, null, null, 0.0, 419.0, '2017-07-24', null, '', 'Y', 'N', '', 1, 1, 7020.4, 11913.3);
INSERT INTO "transactions_account" VALUES (280, 'sample', 2, 3, 32, null, null, 0.0, 127.0, '2016-09-07', null, '', 'Y', 'N', '', 1, 1, 3443.0, 5873.0);
INSERT INTO "transactions_account" VALUES (281, 'sample', 1, 2, 10, null, null, 0.0, 32.0, '2016-09-07', null, '', 'Y', 'N', '', 1, 1, 2462.0, 5905.0);
INSERT INTO "transactions_account" VALUES (282, 'sample', 2, 1, 133, null, 1, 0.0, 230.0, '2016-09-07', null, '', 'Y', 'N', '', 1, 1, 3500.0, 6230.0);
INSERT INTO "transactions_account" VALUES (283, 'sample', 2, 3, 3, 282, null, null, 230.0, '2016-09-07', null, '', 'Y', 'N', null, null, null, 3270.0, 5700.0);
INSERT INTO "transactions_account" VALUES (284, 'sample', 1, 2, 2, 282, null, null, 230.0, '2016-09-07', null, '', 'Y', 'N', null, null, null, 437.85084202085, 6230.0);
INSERT INTO "transactions_account" VALUES (285, 'sample', 1, 1, 134, null, 2, 0.0, 300.0, '2016-09-07', null, '', 'Y', 'N', '', 1, 1, 2430.0, 5930.0);
INSERT INTO "transactions_account" VALUES (286, 'sample', 1, 3, 3, 285, null, null, 300.0, '2016-09-07', null, '', 'Y', 'N', null, null, null, 2430.0, 5930.0);
INSERT INTO "transactions_account" VALUES (287, 'sample', 2, 2, 2, 285, null, null, 48.1154771451484, '2016-09-07', null, '', 'Y', 'N', null, null, null, 3570.0, 6000.0);
INSERT INTO "transactions_account" VALUES (288, 'sample', 2, 3, 32, null, null, 0.0, 95.0, '2016-09-08', null, '', 'Y', 'Y', 'M', 1, 4, 3348.0, 5810.0);
INSERT INTO "transactions_account" VALUES (289, 'sample', 2, 3, 32, 288, null, null, 95.0, '2016-10-08', null, '', 'Y', 'Y', 'M', 2, 4, 7539.0, 9841.0);
INSERT INTO "transactions_account" VALUES (290, 'sample', 2, 3, 32, 288, null, null, 95.0, '2016-11-08', null, '', 'Y', 'Y', 'M', 3, 4, 11210.0, 13476.0);
INSERT INTO "transactions_account" VALUES (291, 'sample', 2, 3, 32, 288, null, null, 95.0, '2016-12-08', null, '', 'Y', 'Y', 'M', 4, 4, 12719.0, 14458.0);
INSERT INTO "transactions_account" VALUES (292, 'sample', 1, 3, 34, null, null, 0.0, 109.0, '2016-09-09', null, '', '', 'N', '', 1, 1, 2353.0, 5701.0);
INSERT INTO "transactions_account" VALUES (293, 'sample', 2, 2, 13, null, null, 0.0, 612.0, '2016-09-16', null, '', 'Y', 'N', '', 0, 1, 3960.0, 6313.0);
INSERT INTO "transactions_account" VALUES (297, 'sample', 2, 1, 133, null, 0, 0.0, 115.0, '2016-09-16', null, '', 'Y', 'N', '', 0, 0, 3348.0, 5701.0);
INSERT INTO "transactions_account" VALUES (298, 'sample', 2, 3, 3, 297, null, null, 115.0, '2016-09-16', null, null, 'Y', 'N', null, null, null, 3845.0, 6179.0);
INSERT INTO "transactions_account" VALUES (299, 'sample', 1, 2, 2, 297, null, null, 115.0, '2016-09-16', null, null, 'Y', '', null, null, null, 2334.0, 1009.46271050521);
INSERT INTO "transactions_account" VALUES (300, 'sample', 1, 3, 34, null, null, 0.0, 21.4915797914996, '2016-09-16', null, '', 'Y', 'N', '', 1, 1, 2219.0, 6179.0);
INSERT INTO "transactions_account" VALUES (301, 'sample', 1, 3, 37, null, null, 0.0, 117.0, '2016-09-18', null, '', 'Y', 'N', '', 1, 0, 2217.0, 6062.0);
INSERT INTO "transactions_account" VALUES (302, 'sample', 1, 3, 100, null, null, 0.0, 8.0, '2016-09-21', null, '', 'Y', 'N', '', 1, 1, 2209.0, 6054.0);
INSERT INTO "transactions_account" VALUES (303, 'sample', 1, 3, 34, null, null, 0.0, 29.0, '2016-09-21', null, '', 'Y', 'N', '', 0, 1, 2180.0, 1013.31194867682);
INSERT INTO "transactions_account" VALUES (304, 'sample', 2, 2, 7, null, null, 0.0, 293.0, '2016-09-21', null, '', 'Y', 'N', '', 1, 1, 4138.0, 6347.0);
INSERT INTO "transactions_account" VALUES (305, 'sample', 2, 2, 6, null, null, 0.0, 615.0, '2016-09-24', null, '', 'Y', '', '', 1, 1, 4753.0, 6933.0);
INSERT INTO "transactions_account" VALUES (306, 'sample', 2, 3, 32, null, null, 0.0, 189.0, '2016-10-07', null, '', 'Y', '', '', 1, 1, 7634.0, 10044.0);
INSERT INTO "transactions_account" VALUES (307, 'sample', 1, 2, 10, null, null, 0.0, 192.0, '2016-10-07', null, '', 'Y', 'N', '', 1, 1, 2302.0, 9936.0);
INSERT INTO "transactions_account" VALUES (308, 'sample', 2, 1, 133, null, 1, 0.0, 230.0, '2016-10-07', null, '', 'Y', '', '', 1, 1, 7634.0, 9744.0);
INSERT INTO "transactions_account" VALUES (309, 'sample', 2, 3, 3, 308, null, null, 230.0, '2016-10-07', null, '', 'Y', 'N', null, null, null, 7823.0, 10233.0);
INSERT INTO "transactions_account" VALUES (310, 'sample', 1, 2, 2, 308, null, null, 36.8885324779471, '2016-10-07', null, '', 'Y', 'N', null, null, null, 2410.0, 10463.0);
INSERT INTO "transactions_account" VALUES (311, 'sample', 1, 1, 134, null, 2, 0.0, 300.0, '2016-10-07', null, '', 'Y', 'N', '', 1, 1, 2302.0, 9936.0);
INSERT INTO "transactions_account" VALUES (312, 'sample', 1, 3, 3, 311, null, null, 48.1154771451484, '2016-10-07', null, '', 'Y', 'N', null, null, null, 2110.0, 9744.0);
INSERT INTO "transactions_account" VALUES (313, 'sample', 2, 2, 2, 311, null, null, 300.0, '2016-10-07', null, '', 'Y', 'N', null, null, null, 1291.5797914996, 10233.0);
INSERT INTO "transactions_account" VALUES (318, 'sample', 1, 3, 34, null, null, 0.0, 92.0, '2016-10-09', null, '', 'Y', 'N', '', 1, 1, 2210.0, 9749.0);
INSERT INTO "transactions_account" VALUES (319, 'sample', 2, 2, 13, null, null, 0.0, 509.0, '2016-10-16', null, '', 'Y', 'N', '', 1, 1, 7898.0, 1621.17080994387);
INSERT INTO "transactions_account" VALUES (320, 'sample', 2, 1, 133, null, 1, 0.0, 150.0, '2016-10-16', null, '', 'Y', 'N', '', 1, 1, 7783.0, 10116.0);
INSERT INTO "transactions_account" VALUES (321, 'sample', 2, 3, 3, 320, null, null, 24.0577385725742, '2016-10-16', null, null, 'Y', 'N', null, null, null, 7389.0, 9599.0);
INSERT INTO "transactions_account" VALUES (322, 'sample', 1, 2, 2, 320, null, null, 150.0, '2016-10-16', null, null, 'Y', 'N', null, null, null, 374.178027265437, 10116.0);
INSERT INTO "transactions_account" VALUES (323, 'sample', 2, 1, 133, null, 1, 0.0, 115.0, '2016-10-16', null, '', 'Y', 'N', '', 1, 1, 7783.0, 1598.39615076183);
INSERT INTO "transactions_account" VALUES (324, 'sample', 2, 3, 3, 323, null, null, 115.0, '2016-10-16', null, null, 'Y', 'N', null, null, null, 7783.0, 9966.0);
INSERT INTO "transactions_account" VALUES (325, 'sample', 1, 2, 2, 323, null, null, 115.0, '2016-10-16', null, null, 'Y', 'N', null, null, null, 2183.0, 10081.0);
INSERT INTO "transactions_account" VALUES (326, 'sample', 1, 3, 34, null, null, 0.0, 142.0, '2016-10-16', null, '', 'Y', 'N', '', 1, 1, 331.676022453889, 9966.0);
INSERT INTO "transactions_account" VALUES (327, 'sample', 1, 3, 37, null, null, 0.0, 13.4723336006415, '2016-10-18', null, '', 'Y', 'N', '', 1, 1, 2249.0, 10032.0);
INSERT INTO "transactions_account" VALUES (328, 'sample', 1, 3, 100, null, null, 0.0, 7.0, '2016-10-21', null, '', '', 'N', '', 1, 1, 2242.0, 10248.0);
INSERT INTO "transactions_account" VALUES (329, 'sample', 1, 3, 34, null, null, 0.0, 6.0, '2016-10-21', null, '', 'Y', 'N', '', 1, 1, 2236.0, 10242.0);
INSERT INTO "transactions_account" VALUES (330, 'sample', 2, 2, 7, null, null, 0.0, 35.7658380112269, '2016-10-21', null, '', 'Y', 'N', '', 1, 1, 8006.0, 10255.0);
INSERT INTO "transactions_account" VALUES (331, 'sample', 2, 2, 6, null, null, 0.0, 476.0, '2016-10-24', null, '', 'Y', 'N', '', 1, 1, 8482.0, 10718.0);
INSERT INTO "transactions_account" VALUES (332, 'sample', 2, 3, 32, null, null, 0.0, 187.0, '2016-11-07', null, '', 'Y', 'N', '', 1, 1, 11295.0, 13531.0);
INSERT INTO "transactions_account" VALUES (333, 'sample', 1, 2, 10, null, null, 0.0, 100.0, '2016-11-07', null, '', 'Y', 'N', '', 1, 1, 2266.0, 13631.0);
INSERT INTO "transactions_account" VALUES (334, 'sample', 2, 1, 133, null, 1, 0.0, 230.0, '2016-11-07', null, '', 'Y', 'N', '', 1, 1, 11482.0, 13718.0);
INSERT INTO "transactions_account" VALUES (335, 'sample', 2, 3, 3, 334, null, null, 230.0, '2016-11-07', null, '', 'Y', 'N', null, null, null, 11065.0, 13231.0);
INSERT INTO "transactions_account" VALUES (336, 'sample', 1, 2, 2, 334, null, null, 230.0, '2016-11-07', null, '', 'Y', 'N', null, null, null, 395.509222133119, 13761.0);
INSERT INTO "transactions_account" VALUES (337, 'sample', 1, 1, 134, null, 2, 0.0, 300.0, '2016-11-07', null, '', 'Y', 'N', '', 1, 1, 2466.0, 13761.0);
INSERT INTO "transactions_account" VALUES (338, 'sample', 1, 3, 3, 337, null, null, 300.0, '2016-11-07', null, '', 'Y', 'N', null, null, null, 2166.0, 13461.0);
INSERT INTO "transactions_account" VALUES (339, 'sample', 2, 2, 2, 337, null, null, 300.0, '2016-11-07', null, '', 'Y', 'N', null, null, null, 11365.0, 13531.0);
INSERT INTO "transactions_account" VALUES (340, 'sample', 2, 3, 32, null, null, 0.0, 60.0, '2016-11-08', null, '', 'Y', 'Y', 'M', 1, 4, 11305.0, 13571.0);
INSERT INTO "transactions_account" VALUES (341, 'sample', 2, 3, 32, 340, null, null, 60.0, '2016-12-08', null, '', 'Y', 'Y', 'M', 2, 4, 12850.0, 14589.0);
INSERT INTO "transactions_account" VALUES (342, 'sample', 2, 3, 32, 340, null, null, 9.62309542902967, '2017-01-08', null, '', 'Y', 'Y', 'M', 3, 4, 15110.0, 16894.0);
INSERT INTO "transactions_account" VALUES (343, 'sample', 2, 3, 32, 340, null, null, 9.62309542902967, '2017-02-08', null, '', 'Y', 'Y', 'M', 4, 4, 57.7, 1788.7);
INSERT INTO "transactions_account" VALUES (344, 'sample', 1, 3, 34, null, null, 0.0, 25.0200481154771, '2016-11-09', null, '', '', 'N', '', 1, 1, 2110.0, 13320.0);
INSERT INTO "transactions_account" VALUES (345, 'sample', 2, 2, 13, null, null, 0.0, 631.0, '2016-11-16', null, '', 'Y', 'N', '', 0, 1, 11841.0, 14032.0);
INSERT INTO "transactions_account" VALUES (346, 'sample', 2, 1, 133, null, 1, 0.0, 150.0, '2016-11-16', null, '', 'Y', 'N', '', 1, 1, 1899.11788291901, 14032.0);
INSERT INTO "transactions_account" VALUES (347, 'sample', 2, 3, 3, 346, null, null, 150.0, '2016-11-16', null, null, 'Y', 'N', null, null, null, 11691.0, 13882.0);
INSERT INTO "transactions_account" VALUES (348, 'sample', 1, 2, 2, 346, null, null, 150.0, '2016-11-16', null, null, 'Y', 'N', null, null, null, 2191.0, 13401.0);
INSERT INTO "transactions_account" VALUES (352, 'sample', 1, 3, 34, null, null, 0.0, 69.0, '2016-11-16', null, '', 'Y', 'N', '', 1, 1, 327.345629510826, 13251.0);
INSERT INTO "transactions_account" VALUES (353, 'sample', 1, 3, 37, null, null, 0.0, 11.0, '2016-11-18', null, '', '', 'N', '', 1, 1, 349.639133921411, 13871.0);
INSERT INTO "transactions_account" VALUES (354, 'sample', 1, 3, 100, null, null, 0.0, 65.0, '2016-11-21', null, '', 'Y', 'N', '', 1, 1, 2115.0, 13806.0);
INSERT INTO "transactions_account" VALUES (355, 'sample', 1, 3, 34, null, null, 0.0, 109.0, '2016-11-21', null, '', 'Y', 'N', '', 1, 1, 2006.0, 13697.0);
INSERT INTO "transactions_account" VALUES (356, 'sample', 2, 2, 7, null, null, 0.0, 157.0, '2016-11-21', null, '', 'Y', '', '', 1, 1, 11848.0, 2221.97273456295);
INSERT INTO "transactions_account" VALUES (357, 'sample', 2, 2, 6, null, null, 0.0, 489.0, '2016-11-24', null, '', 'Y', 'N', '', 1, 1, 12037.0, 14043.0);
INSERT INTO "transactions_account" VALUES (358, 'sample', 2, 3, 32, null, null, 0.0, 227.0, '2016-12-07', null, '', 'Y', 'N', '', 1, 1, 12610.0, 2344.18604651163);
INSERT INTO "transactions_account" VALUES (359, 'sample', 1, 2, 10, null, null, 0.0, 33.0, '2016-12-07', null, '', 'Y', 'N', '', 1, 1, 1739.0, 14649.0);
INSERT INTO "transactions_account" VALUES (363, 'sample', 1, 1, 134, null, 2, 0.0, 300.0, '2016-12-07', null, '', 'Y', 'N', '', 1, 1, 278.909382518043, 14649.0);
INSERT INTO "transactions_account" VALUES (364, 'sample', 1, 3, 3, 363, null, null, 300.0, '2016-12-07', null, '', 'Y', 'N', null, null, null, 1706.0, 14616.0);
INSERT INTO "transactions_account" VALUES (365, 'sample', 2, 2, 2, 363, null, null, 300.0, '2016-12-07', null, '', 'Y', 'N', null, null, null, 12910.0, 14916.0);
INSERT INTO "transactions_account" VALUES (366, 'sample', 2, 3, 32, null, null, 0.0, 36.0, '2016-12-08', null, '', 'Y', 'Y', 'M', 1, 4, 12814.0, 14553.0);
INSERT INTO "transactions_account" VALUES (367, 'sample', 2, 3, 32, 366, null, null, 36.0, '2017-01-08', null, '', 'Y', 'Y', 'M', 2, 1, 2417.64234161989, 16858.0);
INSERT INTO "transactions_account" VALUES (368, 'sample', 2, 3, 32, 366, null, null, 36.0, '2017-02-08', null, '', 'Y', 'Y', '', 3, 4, 117.7, 1848.7);
INSERT INTO "transactions_account" VALUES (369, 'sample', 2, 3, 32, 366, null, null, 36.0, '2017-03-08', null, '', 'Y', 'Y', 'M', 4, 4, 3490.8, 5135.7);
INSERT INTO "transactions_account" VALUES (370, 'sample', 1, 3, 34, null, null, 0.0, 96.0, '2016-12-09', null, '', '', '', '', 1, 1, 1643.0, 14362.0);
INSERT INTO "transactions_account" VALUES (371, 'sample', 2, 2, 13, null, null, 0.0, 498.0, '2016-12-16', null, '', 'Y', 'N', '', 1, 1, 2101.36327185245, 14768.0);
INSERT INTO "transactions_account" VALUES (372, 'sample', 2, 1, 133, null, 0, 0.0, 150.0, '2016-12-16', null, '', '', 'N', '', 1, 1, 13102.0, 14768.0);
INSERT INTO "transactions_account" VALUES (373, 'sample', 2, 3, 3, 372, null, null, 150.0, '2016-12-16', null, null, 'Y', '', null, null, null, 12952.0, 14618.0);
INSERT INTO "transactions_account" VALUES (374, 'sample', 1, 2, 2, 372, null, null, 150.0, '2016-12-16', null, null, 'Y', 'N', null, null, null, 1816.0, 14768.0);
INSERT INTO "transactions_account" VALUES (375, 'sample', 2, 1, 133, null, 1, 0.0, 115.0, '2016-12-16', null, '', '', 'N', '', 1, 1, 2021.4915797915, 14270.0);
INSERT INTO "transactions_account" VALUES (376, 'sample', 2, 3, 3, 375, null, null, 115.0, '2016-12-16', null, null, 'Y', 'N', null, null, null, 12604.0, 14247.0);
INSERT INTO "transactions_account" VALUES (377, 'sample', 1, 2, 2, 375, null, null, 115.0, '2016-12-16', null, null, 'Y', 'N', null, null, null, 1666.0, 14270.0);
INSERT INTO "transactions_account" VALUES (378, 'sample', 1, 3, 34, null, null, 0.0, 92.0, '2016-12-16', null, '', 'Y', 'N', '', 1, 1, 1551.0, 14155.0);
INSERT INTO "transactions_account" VALUES (379, 'sample', 1, 3, 37, null, null, 0.0, 136.0, '2016-12-18', null, '', 'Y', 'N', '', 1, 1, 1680.0, 14632.0);
INSERT INTO "transactions_account" VALUES (380, 'sample', 1, 3, 100, null, null, 0.0, 140.0, '2016-12-21', null, '', 'Y', 'N', '', 1, 1, 230.473135525261, 14361.0);
INSERT INTO "transactions_account" VALUES (381, 'sample', 1, 3, 34, null, null, 0.0, 103.0, '2016-12-21', null, '', 'Y', 'N', '', 1, 1, 1577.0, 2325.74178027265);
INSERT INTO "transactions_account" VALUES (382, 'sample', 2, 2, 7, null, null, 0.0, 272.0, '2016-12-21', null, '', 'Y', '', '', 1, 1, 13224.0, 14904.0);
INSERT INTO "transactions_account" VALUES (383, 'sample', 2, 2, 6, null, null, 0.0, 518.0, '2016-12-24', null, '', 'Y', 'N', '', 1, 1, 13442.0, 14879.0);
INSERT INTO "transactions_account" VALUES (385, 'sample', 2, 2, 5, null, null, 0.0, 3000.0, '2016-09-01', null, 'Salary', 'Y', '', 'M', 1, 12, 3500.0, 6000.0);
INSERT INTO "transactions_account" VALUES (386, 'sample', 2, 2, 5, 385, null, null, 3000.0, '2016-10-01', null, '', 'Y', 'N', '', null, null, 7753.0, 9933.0);
INSERT INTO "transactions_account" VALUES (387, 'sample', 2, 2, 5, 385, null, null, 3000.0, '2016-11-01', null, '', 'Y', 'N', '', null, null, 11482.0, 13718.0);
INSERT INTO "transactions_account" VALUES (388, 'sample', 2, 2, 5, 385, null, null, 3000.0, '2016-12-01', null, '', '', 'N', '', null, null, 12837.0, 14843.0);
INSERT INTO "transactions_account" VALUES (389, 'sample', 2, 2, 5, 385, null, null, 3000.0, '2017-01-01', null, '', 'Y', 'N', '', null, null, 16442.0, 17879.0);
INSERT INTO "transactions_account" VALUES (390, 'sample', 2, 2, 5, 385, null, null, 3000.0, '2017-02-01', null, '', '', '', '', null, null, 608.0, 2368.5);
INSERT INTO "transactions_account" VALUES (391, 'sample', 2, 2, 5, 385, null, null, 3000.0, '2017-03-01', null, '', '', 'N', '', null, null, 3705.7, 5315.7);
INSERT INTO "transactions_account" VALUES (392, 'sample', 2, 2, 5, 385, null, null, 3000.0, '2017-04-01', null, '', 'Y', '', '', null, null, 5183.6, 6632.5);
INSERT INTO "transactions_account" VALUES (393, 'sample', 2, 2, 5, 385, null, null, 3000.0, '2017-05-01', null, '', 'Y', 'N', '', null, null, 9054.0, 10200.9);
INSERT INTO "transactions_account" VALUES (394, 'sample', 2, 2, 5, 385, null, null, 3000.0, '2017-06-01', null, '', 'Y', 'N', '', null, null, 12245.3, 13301.2);
INSERT INTO "transactions_account" VALUES (395, 'sample', 2, 2, 5, 385, null, null, 3000.0, '2017-07-01', null, '', '', 'N', '', null, null, 11416.4, 1923.38412189254);
INSERT INTO "transactions_account" VALUES (396, 'sample', 2, 2, 5, 385, null, null, 3000.0, '2017-08-01', null, '', '', 'N', '', null, null, 3020.4, 7913.3);
INSERT INTO "transactions_account" VALUES (397, 'sample', 2, 3, 48, null, null, 0.0, 18000.0, '2017-01-10', null, 'New Car', 'Y', 'N', '', 0, 1, -3016.0, -1243.0);
INSERT INTO "transactions_account" VALUES (398, 'sample', 2, 1, 133, null, 0, 0.0, 2500.0, '2017-07-20', null, '', 'Y', '', '', 1, 1, 9291.4, 14332.3);
INSERT INTO "transactions_account" VALUES (399, 'sample', 2, 3, 3, 398, null, null, 2500.0, '2017-07-20', null, null, 'Y', 'N', null, null, null, 6791.4, 1897.7225340818);
INSERT INTO "transactions_account" VALUES (400, 'sample', 1, 2, 2, 398, null, null, 2500.0, '2017-07-20', null, null, 'Y', 'N', null, null, null, 5040.9, 14332.3);
INSERT INTO "transactions_account" VALUES (401, 'sample', 2, 1, 133, null, 1, 0.0, 2000.0, '2017-07-03', null, '', 'Y', 'N', '', 1, 1, 9416.4, 11992.3);
INSERT INTO "transactions_account" VALUES (402, 'sample', 2, 3, 3, 401, null, null, 2000.0, '2017-07-03', null, null, 'Y', 'N', null, null, null, 1510.24859663192, 9992.3);
INSERT INTO "transactions_account" VALUES (403, 'sample', 1, 2, 2, 401, null, null, 2000.0, '2017-07-03', null, null, 'Y', 'N', null, null, null, 2575.9, 11992.3);
INSERT INTO "transactions_account" VALUES (404, 'sample', 2, 3, 87, null, null, 0.0, 240.577385725742, '2017-03-15', null, 'Gadgets', '', 'N', '', 1, 1, 1621.6, 521.651964715317);
INSERT INTO "transactions_account" VALUES (405, 'sample', 2, 3, 123, null, null, 0.0, 7000.0, '2017-07-28', null, 'Trip', 'Y', 'N', '', 1, 0, 20.4, 4913.3);
INSERT INTO "transactions_account" VALUES (406, 'sample', 2, 3, 87, null, null, 0.0, 1800.0, '2017-08-28', null, 'Amex', 'Y', 'N', '', 0, 1, 1531.4, 6372.3);
INSERT INTO "transactions_account" VALUES (407, 'sample', 2, 3, 87, null, null, 0.0, 2200.0, '2016-12-01', null, 'Amex', 'Y', 'N', '', 1, 1, 9837.0, 1899.43865276664);
INSERT INTO "transactions_account" VALUES (408, 'sample', 2, 3, 27, null, null, 0.0, 5000.0, '2017-06-05', null, '', 'Y', 'N', '', 1, 1, 7245.3, 8301.2);
INSERT INTO "transactions_account" VALUES (409, 'sample', 2, 3, 17, null, null, 0.0, 300.0, '2016-11-21', null, '', 'Y', 'Y', 'M', 1, 12, 11548.0, 2173.8572574178);
INSERT INTO "transactions_account" VALUES (410, 'sample', 2, 3, 17, 409, null, null, 300.0, '2016-12-21', null, '', 'Y', 'Y', 'M', 2, 4, 2072.81475541299, 14604.0);
INSERT INTO "transactions_account" VALUES (411, 'sample', 2, 3, 17, 409, null, null, 300.0, '2017-01-21', null, '', '', 'Y', 'M', 3, 12, -3053.0, -1184.5);
INSERT INTO "transactions_account" VALUES (412, 'sample', 2, 3, 17, 409, null, null, 300.0, '2017-02-21', null, '', 'Y', 'Y', 'M', 4, 12, 211.7, 1821.7);
INSERT INTO "transactions_account" VALUES (413, 'sample', 2, 3, 17, 409, null, null, 48.1154771451484, '2017-03-21', null, '', 'Y', 'Y', 'M', 1, 12, 242.277465918204, 3063.5);
INSERT INTO "transactions_account" VALUES (414, 'sample', 2, 3, 17, 409, null, null, 300.0, '2017-04-21', null, '', 'Y', '', 'M', 6, 4, 4453.0, 5953.9);
INSERT INTO "transactions_account" VALUES (415, 'sample', 2, 3, 17, 409, null, null, 300.0, '2017-05-21', null, '', 'Y', 'Y', 'M', 7, 12, 8701.3, 9866.2);
INSERT INTO "transactions_account" VALUES (416, 'sample', 2, 3, 17, 409, null, null, 300.0, '2017-06-21', null, '', 'Y', 'Y', 'M', 8, 12, 7268.4, 8087.3);
INSERT INTO "transactions_account" VALUES (417, 'sample', 2, 3, 17, 409, null, null, 300.0, '2017-07-21', null, '', 'Y', 'Y', 'M', 9, 12, 6436.4, 11344.3);
INSERT INTO "transactions_account" VALUES (418, 'sample', 2, 3, 17, 409, null, null, 300.0, '2017-08-21', null, '', 'Y', '', 'M', 10, 12, 2597.4, 7525.3);
INSERT INTO "transactions_account" VALUES (419, 'sample', 2, 3, 17, 409, null, null, 300.0, '2017-09-21', null, '', 'N', 'Y', 'M', 11, 12, 6031.4, 7752.3);
INSERT INTO "transactions_account" VALUES (420, 'sample', 2, 3, 17, 409, null, null, 300.0, '2017-10-21', null, '', 'N', 'Y', 'M', 12, 4, 6031.4, 7752.3);
INSERT INTO "transactions_account" VALUES (421, 'sample', 1, 1, 134, null, 2, 0.0, 3000.0, '2017-09-01', null, 'Deposit', 'Y', 'N', '', 1, 1, 1840.9, 6372.3);
INSERT INTO "transactions_account" VALUES (422, 'sample', 1, 3, 3, 421, null, null, 3000.0, '2017-09-01', null, null, 'Y', 'N', null, null, null, 1840.9, 1022.0208500401);
INSERT INTO "transactions_account" VALUES (423, 'sample', 2, 2, 2, 421, null, null, 3000.0, '2017-09-01', null, null, 'Y', 'N', null, null, null, 4531.4, 9372.3);
INSERT INTO "transactions_account" VALUES (424, 'sample', 1, 3, 19, null, null, 0.0, 120.0, '2017-09-05', null, 'Water', 'Y', 'N', '', 1, 1, 1720.9, 6252.3);
INSERT INTO "transactions_account" VALUES (425, 'sample', 2, 2, 6, null, null, 0.0, 1500.0, '2017-09-05', null, '', 'Y', 'N', '', 0, 1, 6031.4, 1243.35204490778);
INSERT INTO "transactions_account" VALUES (426, 'sample', 2, 3, 71, null, null, 0.0, 800.0, '2017-01-02', null, 'Studies', 'Y', 'N', '', 0, 0, 15642.0, 17079.0);
INSERT INTO "transactions_account" VALUES (427, 'sample', 2, 3, 56, null, null, 0.0, 300.0, '2017-09-06', null, 'Doctor Who', 'Y', 'N', '', 1, 1, 1194.30633520449, 9437.5);

-- ----------------------------
-- Table structure for user_account
-- ----------------------------
DROP TABLE IF EXISTS "user_account";
CREATE TABLE "user_account" (
"user_login"  varchar(50) COLLATE NOCASE NOT NULL,
"account_id"  INTEGER NOT NULL,
"account_name"  varchar(150) COLLATE NOCASE,
"starter_value"  double,
"current_value"  double,
"credit_limit"  double,
"letter_ico"  varchar(150) COLLATE NOCASE,
"color_ico"  varchar(150) COLLATE NOCASE,
"is_active"  varchar(5) COLLATE NOCASE,
"dt_insert"  date,
PRIMARY KEY ("user_login" ASC, "account_id" ASC),
FOREIGN KEY ("account_id") REFERENCES "accounts" ("account_id"),
FOREIGN KEY ("user_login") REFERENCES "sec_users" ("user_login")
)

;

-- ----------------------------
-- Records of user_account
-- ----------------------------
INSERT INTO "user_account" VALUES ('sample', 1, 'Wallet', 80.1924619085806, 1991.0, 0.0, 'Wa', '#d4f5ff', 'Y', '2017-08-02');
INSERT INTO "user_account" VALUES ('sample', 2, 'Bank', 2500.0, 7446.5, 0.0, 'Ba', '#cfdbf3', 'Y', '2017-08-02');

-- ----------------------------
-- View structure for vw_cashflow
-- ----------------------------
DROP VIEW IF EXISTS "vw_cashflow";
CREATE VIEW vw_cashflow as 
	SELECT
		ta.transaction_id AS transaction_id,
		ta.transaction_date AS transaction_date,
		ta.user_login AS user_login,
		ta.account_id AS account_id,
		ua.letter_ico AS letter_ico,
		ua.color_ico AS color_ico,
		ua.account_name AS account_name,
		ta.category_id AS category_id,
		c.category_desc AS category_desc,
		c.category_ico AS category_ico,
		c.category_master AS category_master,
		CASE ta.transaction_recurrence
			WHEN 'Y' then (ta.transaction_desc || ' (' || ta.transaction_num || '/' ||ta.transaction_num_total || ')')
			ELSE ta.transaction_desc
		end as transaction_desc,
		ta.transaction_types_id AS transaction_types_id,
		tt.transaction_types_desc AS transaction_types_desc,
		case ta.transaction_types_id
			when '2' then ta.transaction_actual_amount
			ELSE NULL
		end as income,
		case ta.transaction_types_id
			when '3' then ta.transaction_actual_amount
			ELSE NULL
		end as expense,
		ta.transaction_balance_account AS transaction_balance_account,
		ta.transaction_balance_all AS transaction_balance_all, 
		ta.transaction_consumed AS transaction_consumed
	FROM
		(((transactions_account ta 
		JOIN user_account ua ON ((ua.account_id = ta.account_id))) 
		JOIN categories c ON ((c.category_id = ta.category_id))) 
		JOIN transaction_types tt ON ((tt.transaction_types_id = ta.transaction_types_id)));

-- ----------------------------
-- Indexes structure for table categories
-- ----------------------------
CREATE INDEX "fk_categories_categories1_idx"
ON "categories" ("category_master" ASC);

-- ----------------------------
-- Indexes structure for table planning_goals
-- ----------------------------
CREATE INDEX "fk_planning_goals_sec_users1_idx"
ON "planning_goals" ("user_login" ASC);
CREATE INDEX "planning_goals_type_id"
ON "planning_goals" ("planning_goals_type_id" ASC);

-- ----------------------------
-- Indexes structure for table sec_users
-- ----------------------------
CREATE UNIQUE INDEX "user_email_UNIQUE"
ON "sec_users" ("user_email" ASC);

-- ----------------------------
-- Indexes structure for table transactions_account
-- ----------------------------
CREATE INDEX "fk_transactions_account_categories1_idx"
ON "transactions_account" ("category_id" ASC);
CREATE INDEX "fk_transactions_account_transaction_types1_idx"
ON "transactions_account" ("transaction_types_id" ASC);
CREATE INDEX "fk_transactions_account_transactions_account1_idx"
ON "transactions_account" ("transfer_transaction_id" ASC);
CREATE INDEX "fk_transactions_account_user_account1_idx"
ON "transactions_account" ("user_login" ASC, "account_id" ASC);

-- ----------------------------
-- Indexes structure for table user_account
-- ----------------------------
CREATE INDEX "fk_sec_users_has_accounts_accounts1_idx"
ON "user_account" ("account_id" ASC);
CREATE INDEX "fk_sec_users_has_accounts_sec_users_idx"
ON "user_account" ("user_login" ASC);
