<?php

/**
 * Template scriptcase.
 *
 * Modulo de Seguranca.
 *
 * @package     Template
 * @subpackage  Scriptcase
 * @creation    2009/04/14
 * @copyright   NetMake Solucoes em Informatica
 * @author      Juliano Mesquita dos Santos <juliano@netmake.com.br>
 *
 * $Id: body_security_module_step_config.tpl.php,v 1.16 2012-01-27 20:50:46 vinicius Exp $
 */


/* Protecao contra hacks */

if (!defined('SC_LOCKED_VERSION_8976') || ('CARREGADO4536' != SC_LOCKED_VERSION_8976)) {

    die('<br /><span style="font-weight: bold">Fatal error</span>: ' .

        'invalid access to system file.');

}

$options_schemas = $this->GetVar('options_schemas');

$options_log = $this->GetVar('options_log');

$options_menu = $this->GetVar('options_menu');

$options_api = $this->GetVar('options_api');
$options_smtp_api = $this->GetVar('options_smtp_api');
$config_tam = $this->GetVar('config_tam');
$content_initial_data = $this->GetVar('content_config_initial_data');
$content_add_apps = $this->GetVar('content_config_add_apss');
$content_save_profile = $this->GetVar('content_config_save_profile');
if($this->GetVar('count_langs_prj') == '1'){
    $checkbox_yes = '';
    $checkbox_no  = 'checked="checked"';
}else{
    $checkbox_yes = 'checked="checked"';
    $checkbox_no  = '';
}

$social_checkbox_below = '';
$social_checkbox_beside  = 'checked="checked"';
if($nm_config['flag_versao']['google_auth']['has'] && $_SESSION['nm_session']['module_security']['profile']['tabela_social'] == 'S'){
    $social_checkbox_below = 'checked="checked"';
    $social_checkbox_beside  = '';
}

$tipo_nivel      = $_SESSION['nm_session']['module_security']['profile']['tipo_nivel'];
$tipo_nivel_ldap = $_SESSION['nm_session']['module_security']['profile']['tipo_nivel_ldap'];
?>
<style>
    .tab {
        min-height: 300px;
    }

    .ui.menu.tabular .item {
        text-transform: none !important;
    }

    body {
        font-family: Lato, 'Helvetica Neue', Arial, Helvetica, sans-serif !important;
    }
</style>

<div class="ui grid">
    <div class="left floated twelve wide column" style="text-align: left;">

        <h3 class="ui header"><?php echo nm_get_text_lang("['menu']['conf']"); ?></h3>
    </div>

    <div class="right floated foar wide column"
         style="display: flex; flex-direction: row; justify-content: flex-end; align-items: center;">
        <?php echo $this->GetVar('block_image_help'); ?>
    </div>
</div>
<div class="ui divider"></div>

<div class="ui top attached tabular menu">
    <a class="active item aba_clicked" id='general' data-tab="general" onclick="nm_verify_deps($(this).attr('data-tab'));"><?php echo nm_get_text_lang("['general']"); ?>
        <?php if ($nm_config['is_97']) { ?>
            <span class="field-new-sticker"><?php echo nm_get_text_lang("['menu_new_label']", 'Menu'); ?></span>
        <?php } ?>
    </a>

    <a class="item" data-tab="login" onclick="nm_verify_deps($(this).attr('data-tab'));"><?php echo nm_get_text_lang("['login']"); ?>
        <?php if ($nm_config['is_96']) { ?>
            <span class="field-new-sticker"><?php echo nm_get_text_lang("['menu_new_label']", 'Menu'); ?></span>
        <?php } ?>
    </a>

    <?php if (!($tipo_nivel == 'ldap' && $tipo_nivel_ldap == 'ldap')) { ?>
        <a class="item"
           data-tab="config_email" onclick="nm_verify_deps($(this).attr('data-tab'));"><?php echo nm_get_text_lang("['email_sett']"); ?>

            <?php if (!$nm_config['has_97']) { ?>
                <small class="upgradeOnlyInfo"><?php echo nm_get_text_lang("['upgrade_only_feature']", 'App'); ?></small>
            <?php } else if ($nm_config['is_97']) { ?>
                <span class="field-new-sticker"><?php echo nm_get_text_lang("['menu_new_label']", 'Menu'); ?></span>
            <?php }
            ?></a>
    <?php } ?>
    <?php if ($tipo_nivel != 'ldap') { ?>
        <a class="item" data-tab="users" onclick="nm_verify_deps($(this).attr('data-tab'));"><?php echo nm_get_text_lang("['usr']"); ?></a>
    <?php if ($tipo_nivel != 'ldap_app'): ?>
        <a class="item" data-tab="2fa" onclick="nm_verify_deps($(this).attr('data-tab'));">
            <?php echo nm_get_text_lang("['tab_2fa']"); ?>
            <?php if (!$nm_config['has_97']) { ?>
                <small class="upgradeOnlyInfo"
                       onclick="parent.noPermission();"><?php echo nm_get_text_lang("['upgrade_only_feature']", 'App'); ?></small>
            <?php } else if ($nm_config['is_97']) { ?>
                <span class="field-new-sticker"
                      <?php if (!$nm_config['has_97']) { ?>onclick='parent.noPermission();' <?php } ?>  ><?php echo nm_get_text_lang("['menu_new_label']", 'Menu'); ?></span>
            <?php } ?>
        </a>
        <?php endif; ?>
    <?php } ?>

    <?php if ($tipo_nivel == 'ldap' || $tipo_nivel == 'ldap_app'): ?>
        <a class="item" data-tab="config_ldap" onclick="nm_verify_deps($(this).attr('data-tab'));"><?php echo nm_get_text_lang("['ldap_sett']"); ?></a>
    <?php endif; ?>
    <?php if ($_SESSION['nm_session']['module_security']['profile']['tabela_social'] == 'S'): ?>
        <a class="item" data-tab="config_social" onclick="nm_verify_deps($(this).attr('data-tab'));"><?php echo nm_get_text_lang("['social_network']"); ?></a>
    <?php endif; ?>
    <?php if ($_SESSION['nm_session']['module_security']['profile']['tabela_logged'] == 'S'): ?>
        <a class="item" data-tab="config_logged_user" onclick="nm_verify_deps($(this).attr('data-tab'));"><?php echo nm_get_text_lang("['logged_user']"); ?></a>
    <?php endif; ?>

    <a class="item" data-tab="config_initial_data" onclick="nm_verify_deps($(this).attr('data-tab'));"><?php echo nm_get_text_lang("['menu']['pop']"); ?></a>
    <?php if ($tipo_nivel != 'ldap'): ?>
    <a class="item" data-tab="config_add_apps" onclick="nm_verify_deps($(this).attr('data-tab'));"><?php echo nm_get_text_lang("['menu']['popular_app']"); ?></a>
    <?php endif; ?>

</div>

<div class="ui bottom attached active tab segment" data-tab="general">
    <div class="ui ">

        <div class="ui form">
            <div class="two fields">
                <div class="field">
                    <label><?php echo nm_get_text_lang("['prefix_app']['title']"); ?></label>

                    <input type='text' id='id_prefix_app' name='config_general[prefix_app]' value='app_'>
                </div>
                <div class=" field">
                    <label><?php echo nm_get_text_lang("['folder']['title']"); ?></label>

                    <input type="text" name="config_general[folder_security]" value="Security" size="20"
                           maxlength="64" id='id_folder_security'>

                </div>

            </div>
            <div class="two fields">
                <div class="field">
                    <label><?php echo nm_get_text_lang("['act_sec']['title']"); ?></label>
                    <div class="inline fields">
                        <div class="field">
                            <div class="ui radio checkbox">
                                <input type="radio" name="config_general[set_seg_app]" checked
                                       value="S">
                                <label><?php echo nm_get_text_lang("['option_yes']"); ?></label>
                            </div>
                        </div>
                        <div class="field">
                            <div class="ui radio checkbox">
                                <input type="radio" name="config_general[set_seg_app]"
                                       value="N">
                                <label><?php echo nm_get_text_lang("['option_no']"); ?></label>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="field">
                    <label><?php echo nm_get_text_lang("['remember_me']['title']"); ?></label>
                    <div class="inline fields">
                        <div class="field">
                            <div class="ui radio checkbox"
                                 onclick="$('#id_remember_me_expiry_cookie').removeClass('disabled');">
                                <input type="radio" name="config_general[remember_me]"
                                       value="S" checked>
                                <label><?php echo nm_get_text_lang("['option_yes']"); ?></label>
                            </div>
                        </div>
                        <div class="field">
                            <div class="ui radio checkbox"
                                 onclick="$('#id_remember_me_expiry_cookie').addClass('disabled');">
                                <input type="radio" name="config_general[remember_me]"
                                       value="N">
                                <label><?php echo nm_get_text_lang("['option_no']"); ?></label>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="two fields">
                <div class="field" id='id_remember_me_expiry_cookie'>
                    <label><?php echo nm_get_text_lang("['remember_me_expiry_cookie']['title']"); ?>
                        <?php if (!$nm_config['has_97']) { ?>
                            <small class="upgradeOnlyInfo"><?php echo nm_get_text_lang("['upgrade_only_feature']", 'App'); ?></small>
                        <?php } else if ($nm_config['is_97']) { ?>
                            <span class="field-new-sticker"><?php echo nm_get_text_lang("['menu_new_label']", 'Menu'); ?></span>
                        <?php } ?>
                    </label>
                    <div class="ui right labeled input">

                        <input type='text'
                               name='config_general[remember_me_expiry_cookie]'
                            <?php echo(!$nm_config['has_97'] ? "onchange='parent.noPermission();this.value=\"30\";return false;' " : ''); ?>
                               value="30">
                        <div class="ui label">
                            <?php echo nm_get_text_lang("['days']"); ?>
                        </div>
                    </div>
                </div>
                <div class="field">
                    <label><?php echo nm_get_text_lang("['session']['title']"); ?>
                        <?php if (!$nm_config['has_93']) { ?>
                            <small class="upgradeOnlyInfo"><?php echo nm_get_text_lang("['upgrade_only_feature']", 'App'); ?></small>
                        <?php } else {
                            if ($nm_config['is_93']) { ?>
                                <span class="field-new-sticker"><?php echo nm_get_text_lang("['menu_new_label']", 'Menu'); ?></span>
                            <?php }
                        } ?>
                    </label>
                    <select name='config_general[session]'
                            class='ui fluid dropdown'>
                        <option value='0'><?php echo nm_get_text_lang("['option_session_no']"); ?></option>
                        <option value='R'><?php echo nm_get_text_lang("['option_session_redirect']"); ?></option>
                        <option value='M'><?php echo nm_get_text_lang("['option_session_message']"); ?></option>

                    </select>
                </div>

            </div>
            <div class="fields two">
                <div class=" field">
                    <label><?php echo nm_get_text_lang("['theme']['title']"); ?></label>

                    <select name="config_general[theme]" class='ui fluid dropdown'>
                        <?php echo $options_schemas; ?>
                    </select>
                </div>
                <div class=" field">
                    <label><?php echo nm_get_text_lang("['log']['title']"); ?></label>

                    <select name="config_general[log]" class='ui fluid dropdown'>

                        <?php echo $options_log; ?>

                    </select>
                </div>
            </div>
            <div class="two fields">
                <div class="field">
                    <label><?php echo nm_get_text_lang("['menu']['title']"); ?></label>


                    <select name="config_general[menu]" class='ui fluid dropdown'
                            onchange="if(this.value=='new_menu'){ $('.menuField').removeClass('disabled'); } else { $('.menuField').addClass('disabled'); } ">

                        <?php echo $options_menu; ?>

                    </select>

                </div>

                <div class=" field menuField">
                    <label><?php echo nm_get_text_lang("['menu_layout']['title']"); ?></label>


                    <select name="config_general[menu_layout]" class='ui fluid dropdown'>
                        <option value='h' checked='checked'><?php echo nm_get_text_lang("['horizontal']"); ?></option>
                        <option value='v'><?php echo nm_get_text_lang("['vertical']"); ?></option>
                    </select>

                </div>

            </div>
            <div class="two fields">

                <div class=" field menuField">
                    <label><?php echo nm_get_text_lang("['menu_theme']['title']"); ?></label>


                    <select name="config_general[menu_theme]" class='ui fluid dropdown' id="theme_list">
                        <?php
                        $themes_arr = $this->GetVar('themes_arr');
                        $selected = isset($_SESSION['nm_session']['module_security']['profile']['config_general']['menu_theme']) && isset($themes_arr[$_SESSION['nm_session']['module_security']['profile']['config_general']['menu_theme']]) ? $_SESSION['nm_session']['module_security']['profile']['config_general']['menu_theme'] : 'dark-cobalt';
                        foreach ($themes_arr as $k => $theme) {
                            ?>
                            <option value="<?php echo $k; ?>" <?php echo ($selected == $k? 'selected="selected"' : '');?> ><?php echo $theme['name']; ?></option>
                            <?php
                        }
                        ?>
                    </select>

                </div>
                <div class="field">
                    <label><?php
                        echo nm_get_text_lang("['sweet_alert']['title']");
                        if (!$nm_config['has_94']) { ?>
                            <small class="upgradeOnlyInfo"><?php echo nm_get_text_lang("['upgrade_only_feature']", 'App'); ?></small>
                        <?php } else if ($nm_config['is_94']) { ?>
                            <span class="field-new-sticker"
                                  onclick='parent.noPermission();'><?php echo nm_get_text_lang("['menu_new_label']", 'Menu'); ?></span>
                        <?php }
                        ?></label>

					<div class="inline fields">
                        <div class="field">
                        	<div class="ui radio checkbox">
                                <input type="radio" class="nmInput nm-radio-button" name="config_general[sweet_alert]"
                                       value="S"
                                    <?php echo(!$nm_config['has_94'] ? "onclick='parent.noPermission();return false;' " : 'checked="checked"'); ?>>
                                <label><?php echo nm_get_text_lang("['option_yes']"); ?></label>
                            </div>
                        </div>
                        <div class="field">
    						<div class="ui radio checkbox">
                                <input type="radio" class="nmInput nm-radio-button"
                                       name="config_general[sweet_alert]" <?php echo(!$nm_config['has_94'] ? "checked='checked' onclick='parent.noPermission();' " : ''); ?>
        
                                       value="N">
                                <label><?php echo nm_get_text_lang("['option_no']"); ?></label>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="two fields">
                <div class=" field color_preview">
                    <div class="nm_primary_preview">
                        <div class="nm_secondary_preview">
                            <div class="nm_fontcolor_preview"></div>
                        </div>
                        <div class="nm_fontcolor_preview"></div>
                        <div class="nm_fontcolor_preview"></div>
                        <div class="nm_fontcolor_preview"></div>
                    </div>
                </div>
                <style>
                    .color_preview {
                        display: block;
                    }
                    .color_preview .nm_primary_preview {
                        display: flex;
                        flex-direction: row;
                        justify-content: center;
                        align-items: center;
                        height: 40px;
                        background: var(--nm-primary-color);
                        border-radius: 4px;
                        width: 100%;
                        column-gap: 15px;
                        box-shadow:  0 2px 6px var(--nm-box-shadow);
                    }
                    .color_preview .nm_secondary_preview {
                        display: flex;
                        flex-direction: row;
                        justify-content: center;
                        align-items: center;
                        padding: 8px;
                        margin: -8px;
                        background: var(--nm-secondary-color);
                        border-radius: 6px;
                    }
                    .color_preview .nm_fontcolor_preview {
                        display: block;
                        background: var(--nm-fontcolor-color);
                        border-radius: 10px;
                        width: 48px;
                        height: 10px;
                    }

                </style>
                <style id="preview_swap">

                </style>
                <script>
                    var arr_val = {"theme":"dark-cobalt"};
                    var themes_list = <?php echo json_encode($themes_arr); ?>;

                    $(document).ready(function () {
                        $('#theme_list').val("<?php echo $selected; ?>");
                        security_menu_load_theme()
                    });

                    $('#theme_list').on('change', function (ev) {
                        security_menu_load_theme()
                    });
                    function security_menu_load_theme(){
                        try {
                            loadTheme();
                        }catch(e){}
                    }
                </script>
            </div>
        </div>
    </div>
</div>

<div class="ui bottom attached tab segment" data-tab="login">
    <div class="ui ">
        <div class="ui form grid centered">
            <div class="sixteen wide column">
                <div class="fields two">
                    <div class="field">
                        <label><?php echo nm_get_text_lang("['label_position']['title']"); ?>
                            <?php if (!$nm_config['has_96']) { ?>
                                <small class="upgradeOnlyInfo"><?php echo nm_get_text_lang("['upgrade_only_feature']", 'App'); ?></small>
                            <?php } else if ($nm_config['is_96']) { ?>
                                <span class="field-new-sticker"
                                      onclick='parent.noPermission();'><?php echo nm_get_text_lang("['menu_new_label']", 'Menu'); ?></span>
                            <?php } ?>
                        </label>


                        <select class='ui fluid dropdown' name="config_general[label_position]"
                                id="id_fld_label_position" <?php echo(!$nm_config['has_96'] ? "parent.noPermission();this.value=2" : ''); ?>
                        <option data-corrido="true"
                                value="1"><?php echo nm_get_text_lang("['block_def_pos_beside']", 'App'); ?></option>
                        <option data-corrido="false" selected='selected'
                                value="2"><?php echo nm_get_text_lang("['block_def_pos_above']", 'App'); ?></option>
                        <option data-corrido="false"
                                value="3"><?php echo nm_get_text_lang("['block_def_pos_below']", 'App'); ?></option>
                        <option data-corrido="false"
                                value="4"><?php echo nm_get_text_lang("['block_def_l_watermark']", 'App'); ?></option>
                        </select>


                    </div>
                    <?php if($tipo_nivel != 'ldap' && $tipo_nivel != 'ldap_app'): ?>
                    <div class="field">
                        <label><?php echo nm_get_text_lang("['login_mode']['title']"); ?>
                            <?php if (!$nm_config['has_9_10']) { ?>
                                <small class="upgradeOnlyInfo"><?php echo nm_get_text_lang("['upgrade_only_feature']", 'App'); ?></small>
                            <?php } else if ($nm_config['is_9_10']) { ?>
                                <span class="field-new-sticker"
                                      onclick='parent.noPermission();'><?php echo nm_get_text_lang("['menu_new_label']", 'Menu'); ?></span>
                            <?php } ?>
                        </label>


                        <select class='ui fluid dropdown' name="config_general[login_mode]"
                                id="id_fld_login_mode" <?php echo(!$nm_config['has_9_10'] ? "parent.noPermission();this.value=2" : ''); ?>>
                            <option value="username"><?php echo nm_get_text_lang("['login_mode']['username']"); ?></option>
                            <option value="email"><?php echo nm_get_text_lang("['login_mode']['email']"); ?></option>
                            <option value="both"><?php echo nm_get_text_lang("['login_mode']['both']"); ?></option>
                        </select>


                    </div>
                    <?php endif; ?>
                    <?php if ($tipo_nivel != 'ldap'): ?>
                        <div class="field">

                            <label><?php echo nm_get_text_lang("['crypt']['title']"); ?></label>

                            <select name='config_general[criptografia]' onchange='nm_select_crypt(this.value);'
                                    class='ui fluid dropdown'>

                                <option value=''></option>

                                <option value='md5' selected="selected">MD5</option>
                                <option value='sha1'>SHA1</option>
                                <option value='sha256'>SHA256</option>
                                <option value='sha512'>SHA512</option>

                            </select>

                        </div>
                    <?php endif; ?>
                    <div class="field">
                        <label>
                            <?php echo nm_get_text_lang("['usa_senha_exibir_ocultar']"); ?>
                            <?php if (!$nm_config['has_96']) { ?>
                                <small class="upgradeOnlyInfo"><?php echo nm_get_text_lang("['upgrade_only_feature']", 'App'); ?></small>
                            <?php } else if ($nm_config['is_96']) { ?>
                                <span class="field-new-sticker"
                                      onclick='parent.noPermission();'><?php echo nm_get_text_lang("['menu_new_label']", 'Menu'); ?></span>
                            <?php } ?>
                        </label>
                        <div class="inline fields">

                            <div class="field">
                                <div class="ui radio checkbox">
                                    <input type="radio" class="nmInput nm-radio-button"
                                           name="config_login[usa_senha_exibir_ocultar]"
                                           value="S"
                                        <?php echo(!$nm_config['has_96'] ? "onclick='parent.noPermission();return false;' " : 'checked="checked"'); ?>>

                                    <label><?php echo nm_get_text_lang("['option_yes']"); ?></label>
                                </div>
                            </div>
                            <div class="field">
                                <div class="ui radio checkbox">
                                    <input type="radio" class="nmInput nm-radio-button"
                                           name="config_login[usa_senha_exibir_ocultar]" <?php echo(!$nm_config['has_96'] ? " onclick='parent.noPermission();' checked='checked'" : ''); ?>

                                           value="N">
                                    <label><?php echo nm_get_text_lang("['option_no']"); ?></label>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
                <div class="fields two">
                    <div class=" field">
                        <label><?php echo nm_get_text_lang("['captcha']['title']"); ?>
                            <?php if (!$nm_config['flag_versao']['google_auth']['has']) { ?>
                                <small class="upgradeOnlyInfo"><?php echo nm_get_text_lang("['upgrade_only_feature']", 'App'); ?></small>
                            <?php } else if ($nm_config['flag_versao']['google_auth']['show_new']) { ?>
                                <span class="field-new-sticker"
                                      onclick='parent.noPermission();'><?php echo nm_get_text_lang("['menu_new_label']", 'Menu'); ?></span>
                            <?php } ?>
                        </label>

                        <select class='ui fluid dropdown' name="config_general[use_captcha]" id="id_fld_use_captcha"
                                onchange="nm_change_captcha(this.value)">
                            <option value="N"><?php echo nm_get_text_lang("['option_no']"); ?></option>
                            <option value="S"><?php echo nm_get_text_lang("['option_captcha']"); ?></option>
                            <option value="recaptcha"><?php echo nm_get_text_lang("['option_recaptcha']"); ?> - V2</option>
                            <option value="recaptchav3"><?php echo nm_get_text_lang("['option_recaptcha']"); ?> - V3</option>
                        </select>
                    </div>

                    <div class="fields two">
                        <div class="field" id="id_recaptcha_secret_key">

                            <label><?php echo nm_get_text_lang("['recaptcha_secret_key']['title']"); ?></label>
                            <input type="text" name="config_general[recaptcha_secret_key]" value="">
                            <span id="nm_hidden_error_rec_sec_key"
                                  class="nm_help_red nm_help_hidden"><?php echo nm_get_text_lang("['recaptcha_secret_key']['empty']"); ?></span>
                        </div>
                        <div class="field" id="id_recaptcha_site_key">

                            <label><?php echo nm_get_text_lang("['recaptcha_site_key']['title']"); ?></label>
                            <input type="text" name="config_general[recaptcha_site_key]" value="">
                            <span id="nm_hidden_error_rec_site_key"
                                  class="nm_help_red nm_help_hidden"><?php echo nm_get_text_lang("['recaptcha_site_key']['empty']"); ?></span>
                        </div>
                    </div>
                </div>
                <?php if($tipo_nivel != 'ldap' && $tipo_nivel != 'ldap_app'):?>
                <div class="fields four">
                    <div class="field">

                        <label>
                            <?php echo nm_get_text_lang("['login_buttons_orientation']['title']"); ?>
                            <?php if (!$nm_config['flag_versao']['google_auth']['has']) { ?>
                                <small class="upgradeOnlyInfo"><?php echo nm_get_text_lang("['upgrade_only_feature']", 'App'); ?></small>
                            <?php } else if ($nm_config['flag_versao']['google_auth']['show_new']) { ?>
                                <span class="field-new-sticker"
                                      onclick='parent.noPermission();'><?php echo nm_get_text_lang("['menu_new_label']", 'Menu'); ?></span>
                            <?php } ?>
                        </label>
                        <div class="inline fields">

                            <div class="field">
                                <div class="ui radio checkbox">
                                    <input type="radio" class="nmInput nm-radio-button"
                                           name="config_login[login_buttons_orientation]"
                                           value="beside"
                                        <?php echo(!$nm_config['flag_versao']['google_auth']['has'] ? "onclick='parent.noPermission();return false;' " : $social_checkbox_beside); ?>>

                                    <label><?php echo nm_get_text_lang("['login_buttons_orientation']['beside']"); ?></label>
                                </div>
                            </div>
                            <div class="field">
                                <div class="ui radio checkbox">
                                    <input type="radio" class="nmInput nm-radio-button"
                                           name="config_login[login_buttons_orientation]"
                                        <?php echo(!$nm_config['flag_versao']['google_auth']['has'] ? " onclick='parent.noPermission();' checked='checked'" : $social_checkbox_below); ?>
                                           value="below">
                                    <label><?php echo nm_get_text_lang("['login_buttons_orientation']['below']"); ?></label>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="field">
                        <label><?php echo nm_get_text_lang("['pswd_last_updated']['title']"); ?></label>
                        <div class="ui right labeled input" style="max-width: 200px;">
                            <input name="config_general[pswd_last_updated]" type="number"
                                   value="60"/>
                            <div class="ui label"><?php echo nm_get_text_lang("['days']"); ?></div>
                        </div>
                    </div>
                    <div class="fields two" style="min-width: 350px;margin-right: 10px;margin-left: 10px;">
    					<div class="field">
    						<label><?php echo nm_get_text_lang("['password_strength']['title']"); ?></label>
                            <div class="ui checkbox">
                                <input type="checkbox" name="config_general[password_strength][]" value="uppercase_letter"
                                       checked="checked">
                                <label><?php echo nm_get_text_lang("['password_strength']['uppercase_letter']"); ?></label>
                            </div>
                            <div class="ui checkbox">
                                <input type="checkbox" name="config_general[password_strength][]" value="lowercase_letter"
                                       checked="checked">
                                <label><?php echo nm_get_text_lang("['password_strength']['lowercase_letter']"); ?></label>
                            </div>
                        </div>
                        <div class="field">
                        	<label>&nbsp;</label>
                            <div class="ui checkbox">
                                <input type="checkbox" name="config_general[password_strength][]" value="numbers"
                                       checked="checked">
                                <label><?php echo nm_get_text_lang("['password_strength']['numbers']"); ?></label>
                            </div>
                            <div class="ui checkbox">
                                <input type="checkbox" name="config_general[password_strength][]" value="special_chars"
                                       checked="checked">
                                <label><?php echo nm_get_text_lang("['password_strength']['special_chars']"); ?></label>
                            </div>
    					</div>
                    </div>
                    <div class="field">
                        <label>
                            <?php echo nm_get_text_lang("['show_language']"); ?>
                            <?php if (!$nm_config['has_9_10']) { ?>
                                <small class="upgradeOnlyInfo"><?php echo nm_get_text_lang("['upgrade_only_feature']", 'App'); ?></small>
                            <?php } else if ($nm_config['is_9_10']) { ?>
                                <span class="field-new-sticker"
                                      onclick='parent.noPermission();'><?php echo nm_get_text_lang("['menu_new_label']", 'Menu'); ?></span>
                            <?php } ?>
                        </label>
                        <div class="inline fields">

                            <div class="field">
                                <div class="ui radio checkbox">
                                    <input type="radio" class="nmInput nm-radio-button"
                                           name="config_login[show_language]"
                                           value="S"
                                           <?php echo(!$nm_config['has_9_10'] ? "onclick='parent.noPermission();return false;' " : $checkbox_yes); ?>>

                                    <label><?php echo nm_get_text_lang("['option_yes']"); ?></label>
                                </div>
                            </div>
                            <div class="field">
                                <div class="ui radio checkbox">
                                    <input type="radio" class="nmInput nm-radio-button"
                                           name="config_login[show_language]" <?php echo(!$nm_config['has_96'] ? " onclick='parent.noPermission();' checked='checked'" : $checkbox_no); ?>

                                           value="N">
                                    <label><?php echo nm_get_text_lang("['option_no']"); ?></label>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>

        <h4 class="ui dividing header" style="margin-top:20px"><?php echo nm_get_text_lang("['fields']"); ?></h4>

        <div class="ui form grid centered">
            <?php foreach (['usu', 'pass'] as $item): ?>
                <div class="eight wide column">
                    <h6 class="ui dividing header"><?php echo nm_get_text_lang("['" . $item . "']['title']"); ?></h6>
                    <div class="field">
                        <label for=""><?php echo nm_get_text_lang("['min_size']"); ?></label>
                        <input type='text' name='config_login[<?php echo $item; ?>_tam_min]'
                               value='<?php echo $config_tam[$item . '_tam_min'] ?>'
                               id='id_login_<?php echo $item; ?>_tam_min' size=1
                               onchange='min_max_<?php echo $item; ?>();'>
                    </div>
                    <div class="field">
                        <label><?php echo nm_get_text_lang("['max_size']"); ?></label>
                        <input type='text' name='config_login[<?php echo $item; ?>_tam_max]'
                               value='<?php echo $config_tam[$item . '_tam_max'] ?>'
                               id='id_login_<?php echo $item; ?>_tam_max' size=1
                               onchange='min_max_<?php echo $item; ?>();'>
                    </div>
                    <input type="hidden" name='config_login[<?php echo $item; ?>_todos_carac]' value="all"/>
                </div>
            <?php endforeach; ?>

        </div>


        <?php if ($_SESSION['nm_session']['module_security']['profile']['tabela_social'] != 'S'): ?>
            <div class="eight wide column" style="margin-top:20px">
                <h5 class="ui dividing header"><?php echo nm_get_text_lang("['login_template']"); ?></h5>
                <div class="field">
                    <div class="ui checkbox" style="padding-bottom: 10px;">
                        <input type="checkbox" name="config_login[use_login_template]"
                               onclick="nm_check_login_template($(this));"
                               value="S">
                        <label><?php echo nm_get_text_lang("['use_login_template']"); ?></label>
                    </div>
                </div>
                <div class="field" id="id_config_login_template_div">
                    <!--  <label>Login Template</label> -->
                    <div class="ui action input" style="min-width: 100%;">
                        <select name="config_login[template_login]" class="ui input large nmInput" id="id_config_login_template" style="width: 300px">
                            <?php echo nm_get_extenal_libraries_options(); ?>
                        </select>
                        <a href="javascript:reload_libs()">
                        	<div class="ui button">
                                <i class="fa fa fa-rotate-right"></i>
                            </div>
                        </a>
                        <a href="javascript:parent.nm_exec_menu('libraries')">
                            <div class="ui button">
                            	<i class="fa fa-pencil"></i>
                        	</div>
                        </a>
                    </div>
                </div>
            </div>
        <?php endif; ?>
    </div>
</div>

<div class="ui bottom attached tab segment" data-tab="users">

    <div class="ui ">

        <div class="ui form grid centered">
            <div class="eight wide column">
                <h4 class="ui dividing header"><?php echo nm_get_text_lang("['new_usr']"); ?></h4>
                <div class="grouped fields">
                    <div class="field">
                        <div class="ui  checkbox">
                            <input type="checkbox" name="config_general[perm_new_user]" value="S"
                                   onclick="if(!$(this).is(':checked')){ $('#id_config_general_default_group').addClass('disabled'); } else { $('#id_config_general_default_group').removeClass('disabled'); }"
                                   checked="checked" id="id_perm_new_user">
                            <label><?php echo nm_get_text_lang("['allow_reg_usr']"); ?></label>
                        </div>
                    </div>
                    <div class="field">
                        <div class="ui  checkbox">
                            <input type="checkbox" name="config_general[actve_by_email]" value="S"
                                   checked="checked" id="id_actve_by_email">
                            <label><?php echo nm_get_text_lang("['act_by_mail']"); ?></label>
                        </div>
                    </div>
                    <div class="field">
                        <div class="ui  checkbox">
                            <input type="checkbox" name="config_general[send_mail_to_admin]" value="S"
                                   checked="checked" id="id_send_mail_to_admin">
                            <label><?php echo nm_get_text_lang("['mail_admin']"); ?></label>
                        </div>
                    </div>
                </div>
                <?php if ($tipo_nivel == 'grp') : ?>
                    <div class="ui divider"></div>
                    <div class="field" id='id_config_general_default_group'>
                        <label><?php echo nm_get_text_lang("['default_group']") ?></label>
                        <input name="config_general[default_group]"
                               type="text" value="Group Default"/>
                    </div>
                <?php endif; ?>
            </div>
            <div class="eight wide column">
                <h4 class="ui dividing header"><?php echo nm_get_text_lang("['ret_pass']"); ?></h4>
                <div class="grouped fields">
                    <div class="field">
                        <div class="ui  checkbox">
                            <input type="radio" name="config_ret_pass[reset_pass]" value="email_com_senha"
                                   checked="checked" id="id_ret_pass_send_mail">
                            <label><?php echo nm_get_text_lang("['mail_send']"); ?></label>
                        </div>
                    </div>
                    <div class="field">
                        <div class="ui  checkbox">
                            <input type="radio" name="config_ret_pass[reset_pass]" value="email_com_nova_senha"
                                   checked="checked" id="id_ret_pass_send_mail_reset">
                            <label><?php echo nm_get_text_lang("['mail_reset']"); ?></label>
                        </div>
                    </div>
                    <div class="field">
                        <div class="ui  checkbox">
                            <input type="radio" name="config_ret_pass[reset_pass]" value="email_com_link_senha"
                                   checked="checked" id="id_ret_pass_send_link_mail">
                            <label><?php echo nm_get_text_lang("['mail_new']"); ?></label>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="ui bottom attached tab segment" data-tab="config_email">
    <div class="ui ">
        <div class="ui form centered">

            <div class=" fields three equal width">

                <div class="field" id="id_combobox_smtp_api">
                    <label for=""><?php echo nm_get_text_lang("['api']"); ?></label>

                    <div class="ui action input">
                        <select name="config_general[smtp_api]" id="smtp_api" class='ui input large nmInput '
                                style="width: 100%;">
                            <option value="custom"><?php echo nm_get_text_lang("['custom']"); ?></option>
                            <?php foreach ($options_smtp_api as $mod => $apis): ?>
                                <optgroup label="<?php echo nm_get_text_lang("['mod_" . $mod . "']"); ?>">
                                    <?php foreach ($apis as $api => $desc): ?>
                                        <option value="<?php echo $mod . '__NM__' . $api; ?>"><?php echo $desc; ?></option>
                                    <?php endforeach; ?>
                                </optgroup>
                            <?php endforeach; ?>
                        </select>
                        <a href="javascript: nm_reload_apis('email', 'smtp_api', 1);">
                            <div class="ui button">
                                <i class="fa fa-rotate-right"></i>
                            </div>
                        </a>
                        <a href="javascript: parent.nm_exec_menu('prj_api')">
                            <div class="ui button">
                                <i class="fa fa-pencil"></i>
                            </div>
                        </a>
                    </div>


                </div>
            </div>
            <div class="fields table_custom_smtp two">
                <div class="field ">
                    <label for="id_config_email_smtp_server"><?php echo nm_get_text_lang("['smtp']['server']"); ?></label>
                    <input type="text" name='config_email[smtp_server]' id='id_config_email_smtp_server'
                           class='config_email_custom' placeholder="smtp.example.com"/>
                </div>
                <div class="field ">
                    <label for="id_config_email_smtp_port"><?php echo nm_get_text_lang("['smtp']['port']"); ?></label>
                    <input type="number" name='config_email[smtp_port]' id='id_config_email_smtp_port'
                           class='config_email_custom' placeholder="465"/>
                </div>
            </div>
            <div class="fields two table_custom_smtp">
                <div class="field">
                    <label for="id_config_email_smtp_security"><?php echo nm_get_text_lang("['smtp']['security']"); ?></label>
                    <select class='ui fluid dropdown' name='config_email[smtp_security]'
                            id='id_config_email_smtp_security'>
                        <option value="" selected="selected"></option>
                        <option value="ssl">SSL</option>
                        <option value="tls">TLS</option>
                    </select>
                </div>

                <div class="field">
                    <label for="id_config_email_smtp_user"><?php echo nm_get_text_lang("['smtp']['usr']"); ?></label>
                    <input type="text" name='config_email[smtp_user]' id='id_config_email_smtp_user'
                           class='config_email_custom' placeholder="default@example.com"/>
                </div>
            </div>
            <div class="fields two table_custom_smtp">
                <div class="field">
                    <label for="id_config_email_smtp_pass"><?php echo nm_get_text_lang("['smtp']['pass']"); ?></label>
                    <div class="ui icon input">
                        <input type="text" name='config_email[smtp_pass]' id='id_config_email_smtp_pass'
                               class='config_email_custom' placeholder="********"/>
                        <i class="eye link icon nm_password" onclick="nm_show_password($(this));"></i>
                    </div>
                </div>
                <div class="field">
                    <label for="id_config_email_smtp_email"><?php echo nm_get_text_lang("['smtp']['email']"); ?></label>
                    <input type="text" name='config_email[smtp_email]' id='id_config_email_smtp_email'
                           class='config_email_custom' placeholder="default@example.com"/>
                </div>
            </div>
            <div class="fields two table_custom_smtp">
                <div class="field">
                    <label for="id_config_email_smtp_name"><?php echo nm_get_text_lang("['smtp']['name']"); ?></label>
                    <input type="text" name='config_email[smtp_name]' id='id_config_email_smtp_name'
                           class='config_email_custom'
                           placeholder="<?php echo nm_get_text_lang("['smtp']['name']"); ?>"/>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="ui bottom attached tab segment" data-tab="config_ldap">
    <div class="ui ">

        <div class="ui form centered">
            <div class="seven wide column">
                <div class="field">
                    <label for='id_ldap_server'><?php echo nm_get_text_lang("['ldap_server']"); ?></label>
                    <input type="text" name='config_general[ldap_server]' value='' id='id_ldap_server'>
                </div>
                <div class="field">
                    <label for='id_ldap_dn'><?php echo nm_get_text_lang("['ldap_dn']"); ?></label>
                    <input type="text" name='config_general[ldap_dn]' id='id_ldap_dn' value=''>
                </div>
                <div class="field">
                    <label for='id_ldap_port'><?php echo nm_get_text_lang("['ldap_port']"); ?></label>
                    <input type="text" name='config_general[ldap_port]' id='id_ldap_port' value='389'>
                </div>
                <div class="field">
                    <label for='id_ldap_suffix'><?php echo nm_get_text_lang("['ldap_suffix']"); ?></label>
                    <input type="text" name='config_general[ldap_suffix]' id='id_ldap_suffix' value=''
                           placeholder="@scriptcase.net"></label>
                </div>
            </div>

        </div>
    </div>
</div>

<div class="ui bottom attached tab segment" data-tab="config_social">
    <div class="ui four doubling stackable cards">
        <div class="ui fluid card">
            <div class="content">
                <div class="ui checkbox">
                    <input type="checkbox" name="config_general[option_facebook]" onclick="socialConfig(this)" id="id_social_facebook"
                           value="facebook" class="socialSelect">
                    <label>Facebook</label>
                </div>
            </div>
            <div class="content">
                <div class="ui form">
                    <div class="field">
                        <label for="">App ID</label>
                        <input type="text" name="config_general[facebook_app_id]" disabled="disabled" id="id_fld_facebook_app_id">
                    </div>
                    <div class="field">
                        <label>Secret</label>
                        <input type="text" name="config_general[facebook_secret]" disabled="disabled" id="id_fld_facebook_secret">
                    </div>
                </div>
            </div>
        </div>
        <div class="ui fluid card">
            <div class="content">
                <div class="ui checkbox">
                    <input type="checkbox" name="config_general[option_twitter]" value="twitter" class="socialSelect" id="id_social_twitter"
                           onclick="socialConfig(this)">
                    <label>Twitter (X)</label>
                </div>
            </div>
            <div class="content">
                <div class="ui form">
                    <div class="field">
                        <label>Key</label>
                        <input type="text" disabled="disabled" name="config_general[twitter_key]" id="id_fld_twitter_key">
                    </div>
                    <div class="field">
                        <label>Secret</label>
                        <input type="text" disabled="disabled" name="config_general[twitter_secret]" id="id_fld_twitter_secret">
                    </div>
                </div>
            </div>
        </div>
        <div class="ui fluid card">
            <div class="content">
                <div class="ui checkbox">
                    <input type="checkbox" name="config_general[option_google]" value="google" class="socialSelect" id="id_social_google"
                           <?php if(!$nm_config['flag_versao']['google_auth']['has']) { ?>
                           onclick="nmFrmScaseRunFunc('noPermission');">
                           <?php }else{ ?>
                           onclick="socialConfig(this)">
                            <?php } ?>
                    <label>Google
                        <?php if (!$nm_config['flag_versao']['google_auth']['has']) { ?>
                            <small class="upgradeOnlyInfo"><?php echo nm_get_text_lang("['upgrade_only_feature']", 'App'); ?></small>
                        <?php } else if ($nm_config['flag_versao']['google_auth']['show_new']) { ?>
                            <span class="field-new-sticker"
                                  onclick='parent.noPermission();'><?php echo nm_get_text_lang("['menu_new_label']", 'Menu'); ?></span>
                        <?php } ?>
                    </label>
                </div>
            </div>
            <div class="content">
                <div class="ui form">
                    <div class="field">
                        <label>ClientID</label>
                        <input type="text" disabled="disabled" name="config_general[google_oauth2_client_id]" id="id_fld_google_client_id">
                    </div>
                    <div class="field">
                        <label>Secret</label>
                        <input type="text" disabled="disabled" name="config_general[google_oauth2_secret]" id="id_fld_google_secret">
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php if($tipo_nivel != 'ldap' && $tipo_nivel != 'ldap_app'): ?>
<div class="ui bottom attached tab segment" data-tab="2fa">
    <div class="ui form">
    	<div class="field">
    		<div class="two fields">
    			<div class="field">
                    <label><?php echo nm_get_text_lang("['2fa']['title']"); ?></label>
                    <div class="ui action input" >
                        <select name="2fa[option]" id="2fa_option" class="ui fluid dropdown"
                                onchange="nm_reload_apis(this.value,'2fa_api')" <?php if (!$nm_config['has_97']) { ?> onclick="parent.noPermission();" disabled="disabled" <?php } ?>>
                            <option value="0"><?php echo nm_get_text_lang("['2fa']['none']"); ?></option>
                            <option value="auth"><?php echo nm_get_text_lang("['2fa']['option']"); ?></option>
                            <option value="sms">SMS</option>
                            <option value="email">E-mail</option>
                        </select>
                    </div>
                </div>
                <div class="field">
                    <label><?php echo nm_get_text_lang("['2fa_mode']['title']"); ?></label>
                    <div class="ui action input" >
                        <select name="2fa[mode]" id="2fa_mode" class="ui fluid dropdown"
                            <?php if (!$nm_config['has_97']) { ?> onclick="parent.noPermission();" disabled="disabled" <?php } ?>>
                            <option value="individual"><?php echo nm_get_text_lang("['2fa_mode']['individual']"); ?></option>
                            <option value="all"><?php echo nm_get_text_lang("['2fa_mode']['all']"); ?></option>
                        </select>
                    </div>
                </div>
    		</div>
    	</div>
    	<div class="field">
        	<div class="three fields">
        		<div class="field">
            		<label><?php echo nm_get_text_lang("['2fa_gateway']['title']"); ?></label>
                    <div class="ui action input">
                        <select name="2fa[api]" class="ui input large  " 
                                id="2fa_api" <?php if (!$nm_config['has_97']) { ?> disabled="disabled" onclick="parent.noPermission();" <?php } ?>>
                            <option></option>
                            <?php foreach ($options_api as $mod => $apis): ?>
                                <optgroup label="<?php echo nm_get_text_lang("['mod_" . $mod . "']"); ?>">
                                    <?php foreach ($apis as $api => $desc): ?>
                                        <option value="<?php echo $mod . '__NM__' . $api; ?>"><?php echo $desc; ?></option>
                                    <?php endforeach; ?>
                                </optgroup>
                            <?php endforeach; ?>
                        </select>
                        <a href="javascript: nm_reload_apis($('#2fa_option').val(), '2fa_api');">
                            <div class="ui button">
                                <i class="fa fa fa-rotate-right"></i>
                            </div>
                        </a>
                        <a href="javascript: parent.nm_exec_menu('prj_api')">
                            <div class="ui button">
                                <i class="fa fa-pencil"></i>
                            </div>
                        </a>
                    </div>
            	</div>
            	<div class="field">
            		 <label><?php echo nm_get_text_lang("['2fa_expiry_time']['title']"); ?></label>
                    <div class="ui right labeled input">
            
                        <input name="2fa[2fa_expiry_time]" type="number"
                               id="2fa_expiry_time" <?php if (!$nm_config['has_97']) { ?> disabled="disabled" <?php } ?>
                               value="300"/>
                        <div class="ui label"><?php echo nm_get_text_lang("['seconds']"); ?></div>
                    </div>
            	</div>
                <div class="field">
                    <label><?php echo nm_get_text_lang("['mfa_last_updated']['title']"); ?></label>
                    <div class="ui right labeled input" style="max-width: 200px;">
                        <input name="config_general[mfa_last_updated]" type="number"
                               value="30"/>
                        <div class="ui label"><?php echo nm_get_text_lang("['days']"); ?></div>
                    </div>
                </div>
        	</div>
    	</div>
    </div>
</div>
<?php endif; ?>
<div class="ui bottom attached tab segment" data-tab="config_logged_user">
    <div class="ui ">
        <div class="ui loader"></div>

        <div class="ui form">
            <div class="fields">
                <table>

                    <tr>

                        <td>

                            <label
                                    for='id_logged_show_user'><?php echo nm_get_text_lang("['logged_show_user']"); ?></label>
                        </td>
                        <td>
                            <input type="radio" class="nmInput nm-radio-button" name="config_general[logged_show_user]"
                                   id="opt_set_seg_logged_show_user_Yes" value="S"
                                   checked="checked">
                            <label
                                    for="opt_set_seg_logged_show_user_Yes"
                                    class="nmText"><span></span><?php echo nm_get_text_lang("['option_yes']"); ?>
                            </label>
                            <input type="radio" class="nmInput nm-radio-button" name="config_general[logged_show_user]"
                                   id="opt_set_seg_logged_show_user_no"
                                   value="N"><label
                                    for="opt_set_seg_logged_show_user_no"
                                    class="nmText"><span></span><?php echo nm_get_text_lang("['option_no']"); ?></label>

                        </td>

                    </tr>

                    <tr>

                        <td>
                            <label
                                    for='id_logged_brute_force'><?php echo nm_get_text_lang("['logged_brute_force']"); ?></label>
                        </td>
                        <td>


                            <input type="radio" class="nmInput nm-radio-button"
                                   name="config_general[logged_brute_force]"
                                   id='id_config_general_logged_brute_force_S'
                                   value="S"
                                   checked="checked">
                            <label class="nmText"
                                   for='id_config_general_logged_brute_force_S'><span></span><?php echo nm_get_text_lang("['option_yes']"); ?>
                            </label>
                            <input type="radio" class="nmInput nm-radio-button"
                                   id='id_config_general_logged_brute_force'
                                   name="config_general[logged_brute_force]"
                                   value="N">
                            <label class="nmText"
                                   for='id_config_general_logged_brute_force'><span></span><?php echo nm_get_text_lang("['option_no']"); ?>
                            </label>


                        </td>

                    </tr>
                    <tr>

                        <td>
                            <label
                                    for='id_logged_brute_force_time'><?php echo nm_get_text_lang("['logged_brute_force_time']"); ?></label>
                        </td>
                        <td>
                            <input type="text" class="nmInput" name="config_general[logged_brute_force_time]"
                                   size='1' value="10"
                                   onkeyup="if (/\D/g.test(this.value)) this.value = this.value.replace(/\D/g,'')"
                                   onchange="if(this.value==''){ this.value=10}">

                        </td>

                    </tr>
                    <tr>

                        <td>
                            <label
                                    for='id_logged_brute_force_attempts'><?php echo nm_get_text_lang("['logged_brute_force_attempts']"); ?></label>
                        </td>
                        <td>
                            <input type="text" class="nmInput" name="config_general[logged_brute_force_attempts]"
                                   size='1' value="10"
                                   onkeyup="if (/\D/g.test(this.value)) this.value = this.value.replace(/\D/g,'')"
                                   onchange="if(this.value==''){ this.value=10}">

                        </td>

                    </tr>

                </table>
            </div>
        </div>
    </div>
</div>
<div class="ui bottom attached tab segment" data-tab="config_initial_data">
    <?php $this->Display($content_initial_data, 'security_module2'); ?>
</div>
<?php if ($tipo_nivel != 'ldap'): ?>
<div class="ui bottom attached tab segment" data-tab="config_add_apps">
    <?php $this->Display($content_add_apps, 'security_module2'); ?>
</div>
<?php endif; ?>

<input type='hidden' id='id_hid_has_app'/>
<div class="ui modal tiny" id="modal-save-perfil">
    <div class="content">
		<span id="modal-save-perfil-span-description">
			<?php $this->Display($content_save_profile, 'security_module2'); ?>
		</span>
    </div>
    <div class="actions">
        <div class="ui cancel button">
            Cancel
        </div>
        <div class="ui primary approve button">
            OK
        </div>
    </div>
</div>
<div class="ui modal tiny" id="modal-all-tabs-click">
    <div class="content">
		<span id="modal-all-tabs-click-span-description"></span>
	</div>
    <div class="actions">
        <div class="ui cancel button">
        	Cancel
        </div>
        <div class="ui primary approve button">
        	OK
        </div>
    </div>
</div>
<style>
    <?php if ($nm_config['flag_versao']['ssh_connection']['show_new']) { ?>
    .item[data-value="recaptchav3"] {
        color: #008000 !important;
    }

    <?php } ?>
</style>
<div class="ui modal tiny" id="modal-warning-apps-opened">
    <div class="content">
		<span id="modal-warning-apps-opened-span-description">
			<?php echo nm_get_text_lang("['warning_apps_opened']"); ?>
		</span>
    </div>
    <div class="actions">
        <div id="btn-cancel" class="ui cancel button">
            <?php echo nm_get_text_lang("['option_no']"); ?>
        </div>
        <div id="btn-approve" class="ui primary approve button">
            <?php echo nm_get_text_lang("['option_yes']"); ?>
        </div>
    </div>
</div>