PRAGMA foreign_keys = OFF;

-- ----------------------------
-- Table structure for "tb_benefits"
-- ----------------------------
DROP TABLE "tb_benefits";
CREATE TABLE "tb_benefits" (
"benefit_id"  INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
"benefit_description"  VARCHAR(45) COLLATE NOCASE NOT NULL,
"benefit_note"  VARCHAR(60) COLLATE NOCASE
);

-- ----------------------------
-- Records of tb_benefits
-- ----------------------------
INSERT INTO "tb_benefits" VALUES (1, 'Disability', null);
INSERT INTO "tb_benefits" VALUES (2, 'Vacation Time', null);
INSERT INTO "tb_benefits" VALUES (3, 'Medical', null);
INSERT INTO "tb_benefits" VALUES (4, 'Dental', null);
INSERT INTO "tb_benefits" VALUES (5, 'Vision', null);
INSERT INTO "tb_benefits" VALUES (6, 'Life', null);
INSERT INTO "tb_benefits" VALUES (7, '401K', null);
INSERT INTO "tb_benefits" VALUES (8, '401K Match', null);
INSERT INTO "tb_benefits" VALUES (9, 'Flexible Spending', null);
INSERT INTO "tb_benefits" VALUES (10, 'Stock Options', null);
INSERT INTO "tb_benefits" VALUES (11, 'Education Reimbursement', null);
INSERT INTO "tb_benefits" VALUES (12, 'PTO', null);

-- ----------------------------
-- Table structure for "tb_candidates"
-- ----------------------------
DROP TABLE "tb_candidates";
CREATE TABLE "tb_candidates" (
"candidate_id"  INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
"candidate_name"  VARCHAR(250) COLLATE NOCASE NOT NULL,
"candidate_courtesy_title"  VARCHAR(45) COLLATE NOCASE,
"candidate_birth_date"  DATE,
"candidate_address"  VARCHAR(250) COLLATE NOCASE,
"candidate_city"  VARCHAR(150) COLLATE NOCASE,
"candidate_state"  VARCHAR(20) COLLATE NOCASE,
"candidate_zip"  VARCHAR(20) COLLATE NOCASE,
"candidate_email"  VARCHAR(150) COLLATE NOCASE,
"candidate_phone"  VARCHAR(45) COLLATE NOCASE,
"candidate_resume"  BLOB,
"candidate_resume_filename"  VARCHAR(100) COLLATE NOCASE,
"candidate_resume_filesize"  INTEGER,
"candidate_notes"  TEXT COLLATE NOCASE,
"tb_sec_users_user_login"  VARCHAR(50) COLLATE NOCASE NOT NULL
);

-- ----------------------------
-- Records of tb_candidates
-- ----------------------------
INSERT INTO "tb_candidates" VALUES (1, 'Eldrich Thomas', 'Mr', '1984-01-31', null, null, null, null, null, null, null, null, 0, null, 'eldrich');
INSERT INTO "tb_candidates" VALUES (2, 'Mary Jane', 'Ms', '1988-11-11', null, null, null, null, 'mary@scriptcase.net', null, 'RESUME', 'resume.txt', 6, null, 'mary');

-- ----------------------------
-- Table structure for "tb_candidates_submissions"
-- ----------------------------
DROP TABLE "tb_candidates_submissions";
CREATE TABLE "tb_candidates_submissions" (
"requisition_id"  INTEGER(11) NOT NULL,
"candidate_id"  INTEGER(11) NOT NULL,
"submission_date"  DATE,
"submission_status_id"  INTEGER(11),
"submission_interview_date"  DATE,
"submission_interview_address"  VARCHAR(250) COLLATE NOCASE,
"submission_rating"  INTEGER(11),
PRIMARY KEY ("requisition_id", "candidate_id")
);

-- ----------------------------
-- Records of tb_candidates_submissions
-- ----------------------------
INSERT INTO "tb_candidates_submissions" VALUES (1, 1, '2013-10-30', 3, '2013-12-20 00:00:00', 'Kennedy Avenue 1001', 0);
INSERT INTO "tb_candidates_submissions" VALUES (1, 2, '2013-11-13', 1, null, null, null);
INSERT INTO "tb_candidates_submissions" VALUES (3, 2, '2014-02-03', 1, null, null, null);

-- ----------------------------
-- Table structure for "tb_companies"
-- ----------------------------
DROP TABLE "tb_companies";
CREATE TABLE "tb_companies" (
"company_id"  INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
"company_name"  VARCHAR(150) COLLATE NOCASE NOT NULL,
"company_address"  VARCHAR(250) COLLATE NOCASE,
"company_country"  VARCHAR(100) COLLATE NOCASE,
"company_city"  VARCHAR(150) COLLATE NOCASE,
"company_state"  VARCHAR(20) COLLATE NOCASE,
"company_zip"  VARCHAR(20) COLLATE NOCASE,
"company_url"  VARCHAR(45) COLLATE NOCASE,
"industry_id"  INTEGER NOT NULL
);

-- ----------------------------
-- Records of tb_companies
-- ----------------------------
INSERT INTO "tb_companies" VALUES (1, 'Netmake', 'Kennedy 1001', 'BR', 'Olinda', 'PE', '53230-630', 'www.scriptcase.net', 9);
INSERT INTO "tb_companies" VALUES (2, 'Sample company', null, 'US', null, null, null, null, 7);
INSERT INTO "tb_companies" VALUES (3, 'Scriptcase Company', null, 'BR', null, null, null, null, 9);

-- ----------------------------
-- Table structure for "tb_contacts"
-- ----------------------------
DROP TABLE "tb_contacts";
CREATE TABLE "tb_contacts" (
"contact_id"  INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
"contact_name"  VARCHAR(250) COLLATE NOCASE NOT NULL,
"job_position_id"  INTEGER,
"contact_phone"  VARCHAR(45) COLLATE NOCASE,
"contact_email"  VARCHAR(150) COLLATE NOCASE,
"company_id"  INTEGER NOT NULL,
"tb_sec_users_user_login"  VARCHAR(50) COLLATE NOCASE NOT NULL
);

-- ----------------------------
-- Records of tb_contacts
-- ----------------------------
INSERT INTO "tb_contacts" VALUES (2, 'Phill Morrison', 17, 555, 'info@scriptcase.net', 1, 'phill');
INSERT INTO "tb_contacts" VALUES (3, 'John Mayer', 13, null, 'info@scriptcase.net', 1, 'mayer');
INSERT INTO "tb_contacts" VALUES (5, 'Alice key', 1, null, 'news@scriptcase.net', 1, 'alice');
INSERT INTO "tb_contacts" VALUES (6, 'Andy Leroy', 4, null, null, 2, 'andy');
INSERT INTO "tb_contacts" VALUES (7, 'Paul Walsh', 4, null, null, 3, 'paul');

-- ----------------------------
-- Table structure for "tb_experiences"
-- ----------------------------
DROP TABLE "tb_experiences";
CREATE TABLE "tb_experiences" (
"experience_id"  INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
"experience_start_date"  DATE,
"experience_end_date"  DATE,
"candidate_id"  INTEGER NOT NULL,
"company_id"  INTEGER,
"tb_job_positions_position_id"  INTEGER,
"experience_summary"  TEXT COLLATE NOCASE
);

-- ----------------------------
-- Records of tb_experiences
-- ----------------------------
INSERT INTO "tb_experiences" VALUES (1, '2008-10-01', '2010-10-01', 1, 2, 18, 'Great experience selling the software xxx in the whole USA.');

-- ----------------------------
-- Table structure for "tb_industries"
-- ----------------------------
DROP TABLE "tb_industries";
CREATE TABLE "tb_industries" (
"industry_id"  INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
"industry_description"  VARCHAR(60) COLLATE NOCASE NOT NULL
);

-- ----------------------------
-- Records of tb_industries
-- ----------------------------
INSERT INTO "tb_industries" VALUES (1, 'Banking');
INSERT INTO "tb_industries" VALUES (2, 'Consulting - Financial');
INSERT INTO "tb_industries" VALUES (3, 'Consulting - IT');
INSERT INTO "tb_industries" VALUES (4, 'Financial');
INSERT INTO "tb_industries" VALUES (5, 'Hardware');
INSERT INTO "tb_industries" VALUES (6, 'Healthcare');
INSERT INTO "tb_industries" VALUES (7, 'Manufacturing');
INSERT INTO "tb_industries" VALUES (8, 'Pharma');
INSERT INTO "tb_industries" VALUES (9, 'Software');
INSERT INTO "tb_industries" VALUES (10, 'Telcom');
INSERT INTO "tb_industries" VALUES (11, 'Transportation');
INSERT INTO "tb_industries" VALUES (12, 'Other');

-- ----------------------------
-- Table structure for "tb_job_positions"
-- ----------------------------
DROP TABLE "tb_job_positions";
CREATE TABLE "tb_job_positions" (
"position_id"  INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
"position_description"  VARCHAR(60) COLLATE NOCASE NOT NULL
);

-- ----------------------------
-- Records of tb_job_positions
-- ----------------------------
INSERT INTO "tb_job_positions" VALUES (1, 'Admin Assistant');
INSERT INTO "tb_job_positions" VALUES (2, 'Customer Service Manager');
INSERT INTO "tb_job_positions" VALUES (3, 'Executive');
INSERT INTO "tb_job_positions" VALUES (4, 'HR');
INSERT INTO "tb_job_positions" VALUES (5, 'IT - QA');
INSERT INTO "tb_job_positions" VALUES (6, 'IT - Software Engineer');
INSERT INTO "tb_job_positions" VALUES (7, 'IT - Technical Support');
INSERT INTO "tb_job_positions" VALUES (8, 'IT - Systems Analyst');
INSERT INTO "tb_job_positions" VALUES (9, 'IT - Web Developper');
INSERT INTO "tb_job_positions" VALUES (10, 'IT - Writting');
INSERT INTO "tb_job_positions" VALUES (11, 'Marketing Executive');
INSERT INTO "tb_job_positions" VALUES (12, 'Sales Manager');
INSERT INTO "tb_job_positions" VALUES (13, 'Accountant');
INSERT INTO "tb_job_positions" VALUES (14, 'CFO');
INSERT INTO "tb_job_positions" VALUES (15, 'CIO');
INSERT INTO "tb_job_positions" VALUES (16, 'COO');
INSERT INTO "tb_job_positions" VALUES (17, 'CEO');
INSERT INTO "tb_job_positions" VALUES (18, 'Sales Representative');
INSERT INTO "tb_job_positions" VALUES (19, 'Product Manager');
INSERT INTO "tb_job_positions" VALUES (20, 'Systems Administrator');
INSERT INTO "tb_job_positions" VALUES (21, 'IT - DBA');

-- ----------------------------
-- Table structure for "tb_requisitions"
-- ----------------------------
DROP TABLE "tb_requisitions";
CREATE TABLE "tb_requisitions" (
"requisition_id"  INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
"contact_id"  INTEGER NOT NULL,
"requisition_target_fill_date"  DATE,
"status_id"  INTEGER,
"urgency_id"  INTEGER,
"type_id"  INTEGER,
"position_id"  INTEGER,
"requisition_title"  VARCHAR(150) COLLATE NOCASE,
"requisition_description"  TEXT COLLATE NOCASE,
"requisition_contract_duration"  VARCHAR(45) COLLATE NOCASE,
"requisition_location"  VARCHAR(250) COLLATE NOCASE,
"requisition_salary"  REAL(10,2),
"requisition_requirements"  TEXT COLLATE NOCASE,
"required_education"  INTEGER
);

-- ----------------------------
-- Records of tb_requisitions
-- ----------------------------
INSERT INTO "tb_requisitions" VALUES (1, 5, '2014-01-31', 1, 2, 1, 1, null, null, null, null, 1500.0, null, 5);
INSERT INTO "tb_requisitions" VALUES (2, 2, '2014-01-31', 1, 1, 1, 8, null, null, null, null, 0.0, null, 2);
INSERT INTO "tb_requisitions" VALUES (3, 2, '2014-02-28', 1, 3, 2, 7, null, null, null, null, 0.0, null, 6);
INSERT INTO "tb_requisitions" VALUES (4, 7, '2014-06-01', 1, 3, 1, 1, 'Admin assistant', null, null, null, 1500.0, null, 2);
INSERT INTO "tb_requisitions" VALUES (5, 6, '2014-03-01', 1, 1, 4, 7, 'Technical Support', null, '2 years', null, 0.0, null, 6);

-- ----------------------------
-- Table structure for "tb_requisitions_has_benefits"
-- ----------------------------
DROP TABLE "tb_requisitions_has_benefits";
CREATE TABLE "tb_requisitions_has_benefits" (
"requisition_id"  INTEGER(11) NOT NULL,
"benefit_id"  INTEGER(11) NOT NULL,
PRIMARY KEY ("requisition_id", "benefit_id")
);

-- ----------------------------
-- Records of tb_requisitions_has_benefits
-- ----------------------------
INSERT INTO "tb_requisitions_has_benefits" VALUES (1, 2);
INSERT INTO "tb_requisitions_has_benefits" VALUES (1, 3);
INSERT INTO "tb_requisitions_has_benefits" VALUES (1, 4);
INSERT INTO "tb_requisitions_has_benefits" VALUES (1, 9);
INSERT INTO "tb_requisitions_has_benefits" VALUES (2, 2);
INSERT INTO "tb_requisitions_has_benefits" VALUES (2, 3);
INSERT INTO "tb_requisitions_has_benefits" VALUES (2, 4);
INSERT INTO "tb_requisitions_has_benefits" VALUES (2, 9);
INSERT INTO "tb_requisitions_has_benefits" VALUES (3, 2);
INSERT INTO "tb_requisitions_has_benefits" VALUES (4, 2);
INSERT INTO "tb_requisitions_has_benefits" VALUES (4, 3);
INSERT INTO "tb_requisitions_has_benefits" VALUES (4, 6);
INSERT INTO "tb_requisitions_has_benefits" VALUES (5, 2);
INSERT INTO "tb_requisitions_has_benefits" VALUES (5, 3);

-- ----------------------------
-- Table structure for "tb_req_education"
-- ----------------------------
DROP TABLE "tb_req_education";
CREATE TABLE "tb_req_education" (
"education_id"  INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
"education_description"  VARCHAR(45) COLLATE NOCASE NOT NULL
);

-- ----------------------------
-- Records of tb_req_education
-- ----------------------------
INSERT INTO "tb_req_education" VALUES (1, 'Associates');
INSERT INTO "tb_req_education" VALUES (2, 'Bachelors');
INSERT INTO "tb_req_education" VALUES (3, 'Certificate');
INSERT INTO "tb_req_education" VALUES (4, 'HS/GED');
INSERT INTO "tb_req_education" VALUES (5, 'Masters');
INSERT INTO "tb_req_education" VALUES (6, 'None');
INSERT INTO "tb_req_education" VALUES (7, 'PhD');

-- ----------------------------
-- Table structure for "tb_req_status"
-- ----------------------------
DROP TABLE "tb_req_status";
CREATE TABLE "tb_req_status" (
"status_id"  INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
"status_description"  VARCHAR(45) COLLATE NOCASE NOT NULL
);

-- ----------------------------
-- Records of tb_req_status
-- ----------------------------
INSERT INTO "tb_req_status" VALUES (1, 'Hiring');
INSERT INTO "tb_req_status" VALUES (2, 'Filled');
INSERT INTO "tb_req_status" VALUES (3, 'Closed');
INSERT INTO "tb_req_status" VALUES (4, 'On-Hold');

-- ----------------------------
-- Table structure for "tb_req_types"
-- ----------------------------
DROP TABLE "tb_req_types";
CREATE TABLE "tb_req_types" (
"type_id"  INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
"typ_description"  VARCHAR(45) COLLATE NOCASE NOT NULL
);

-- ----------------------------
-- Records of tb_req_types
-- ----------------------------
INSERT INTO "tb_req_types" VALUES (1, 'Full-time');
INSERT INTO "tb_req_types" VALUES (2, 'Part-time');
INSERT INTO "tb_req_types" VALUES (3, 'Part-time temp');
INSERT INTO "tb_req_types" VALUES (4, 'Full-time temp');
INSERT INTO "tb_req_types" VALUES (5, 'Contract 1099');
INSERT INTO "tb_req_types" VALUES (6, 'Contract W-9');

-- ----------------------------
-- Table structure for "tb_req_urgencies"
-- ----------------------------
DROP TABLE "tb_req_urgencies";
CREATE TABLE "tb_req_urgencies" (
"urgency_id"  INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
"urgency_description"  VARCHAR(45) COLLATE NOCASE NOT NULL
);

-- ----------------------------
-- Records of tb_req_urgencies
-- ----------------------------
INSERT INTO "tb_req_urgencies" VALUES (1, 'Hot');
INSERT INTO "tb_req_urgencies" VALUES (2, 'Warm');
INSERT INTO "tb_req_urgencies" VALUES (3, 'Cold');

-- ----------------------------
-- Table structure for "tb_sc_log"
-- ----------------------------
DROP TABLE "tb_sc_log";
CREATE TABLE "tb_sc_log" (
"id"  INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
"inserted_date"  DATE,
"username"  VARCHAR(90) COLLATE NOCASE NOT NULL,
"application"  VARCHAR(200) COLLATE NOCASE NOT NULL,
"creator"  VARCHAR(30) COLLATE NOCASE NOT NULL,
"ip_user"  VARCHAR(32) COLLATE NOCASE NOT NULL,
"action"  VARCHAR(30) COLLATE NOCASE NOT NULL,
"description"  TEXT COLLATE NOCASE
);

-- ----------------------------
-- Records of tb_sc_log
-- ----------------------------

-- ----------------------------
-- Table structure for "tb_sec_applications"
-- ----------------------------
DROP TABLE "tb_sec_applications";
CREATE TABLE "tb_sec_applications" (
"applications_id"  VARCHAR(150) COLLATE NOCASE NOT NULL,
"applications_description"  TEXT COLLATE NOCASE,
PRIMARY KEY ("applications_id")
);

-- ----------------------------
-- Records of tb_sec_applications
-- ----------------------------
INSERT INTO "tb_sec_applications" VALUES ('app_grid_log', 'cons');
INSERT INTO "tb_sec_applications" VALUES ('blank_submit_candidate', 'blank');
INSERT INTO "tb_sec_applications" VALUES ('control_change_psw', 'contr');
INSERT INTO "tb_sec_applications" VALUES ('control_sync_apps', 'contr');
INSERT INTO "tb_sec_applications" VALUES ('form_add_candidate', 'form');
INSERT INTO "tb_sec_applications" VALUES ('form_add_company', 'form');
INSERT INTO "tb_sec_applications" VALUES ('form_add_contact', 'form');
INSERT INTO "tb_sec_applications" VALUES ('form_edit_candidate', 'form');
INSERT INTO "tb_sec_applications" VALUES ('form_look_candidate', 'form');
INSERT INTO "tb_sec_applications" VALUES ('form_look_requisition', 'form');
INSERT INTO "tb_sec_applications" VALUES ('form_tb_benefits', 'form');
INSERT INTO "tb_sec_applications" VALUES ('form_tb_candidates', 'form');
INSERT INTO "tb_sec_applications" VALUES ('form_tb_candidates_submissions', 'form');
INSERT INTO "tb_sec_applications" VALUES ('form_tb_companies', 'form');
INSERT INTO "tb_sec_applications" VALUES ('form_tb_contacts', 'form');
INSERT INTO "tb_sec_applications" VALUES ('form_tb_experiences', 'form');
INSERT INTO "tb_sec_applications" VALUES ('form_tb_industries', 'form');
INSERT INTO "tb_sec_applications" VALUES ('form_tb_job_positions', 'form');
INSERT INTO "tb_sec_applications" VALUES ('form_tb_requisitions', 'form');
INSERT INTO "tb_sec_applications" VALUES ('form_tb_req_education', 'form');
INSERT INTO "tb_sec_applications" VALUES ('form_tb_req_status', 'form');
INSERT INTO "tb_sec_applications" VALUES ('form_tb_req_types', 'form');
INSERT INTO "tb_sec_applications" VALUES ('form_tb_req_urgencies', 'form');
INSERT INTO "tb_sec_applications" VALUES ('form_tb_sec_applications', 'form');
INSERT INTO "tb_sec_applications" VALUES ('form_tb_sec_groups', 'form');
INSERT INTO "tb_sec_applications" VALUES ('form_tb_sec_groups_applications', 'form');
INSERT INTO "tb_sec_applications" VALUES ('form_tb_submission_status', 'form');
INSERT INTO "tb_sec_applications" VALUES ('grid_search_jobs', 'cons');
INSERT INTO "tb_sec_applications" VALUES ('grid_submitted_candidate', 'cons');
INSERT INTO "tb_sec_applications" VALUES ('grid_tb_benefits', 'cons');
INSERT INTO "tb_sec_applications" VALUES ('grid_tb_candidates', 'cons');
INSERT INTO "tb_sec_applications" VALUES ('grid_tb_candidates_submissions', 'cons');
INSERT INTO "tb_sec_applications" VALUES ('grid_tb_companies', 'cons');
INSERT INTO "tb_sec_applications" VALUES ('grid_tb_contacts', 'cons');
INSERT INTO "tb_sec_applications" VALUES ('grid_tb_contacts_detail', 'cons');
INSERT INTO "tb_sec_applications" VALUES ('grid_tb_experiences', 'cons');
INSERT INTO "tb_sec_applications" VALUES ('grid_tb_industries', 'cons');
INSERT INTO "tb_sec_applications" VALUES ('grid_tb_job_positions', 'cons');
INSERT INTO "tb_sec_applications" VALUES ('grid_tb_requisitions', 'cons');
INSERT INTO "tb_sec_applications" VALUES ('grid_tb_requisitions_has_benefits', 'cons');
INSERT INTO "tb_sec_applications" VALUES ('grid_tb_req_education', 'cons');
INSERT INTO "tb_sec_applications" VALUES ('grid_tb_req_status', 'cons');
INSERT INTO "tb_sec_applications" VALUES ('grid_tb_req_types', 'cons');
INSERT INTO "tb_sec_applications" VALUES ('grid_tb_req_urgencies', 'cons');
INSERT INTO "tb_sec_applications" VALUES ('grid_tb_sec_applications', 'cons');
INSERT INTO "tb_sec_applications" VALUES ('grid_tb_sec_groups', 'cons');
INSERT INTO "tb_sec_applications" VALUES ('grid_tb_submission_status', 'cons');
INSERT INTO "tb_sec_applications" VALUES ('login', 'contr');
INSERT INTO "tb_sec_applications" VALUES ('menu', null);
INSERT INTO "tb_sec_applications" VALUES ('search_tb_sec_groups', 'filter');

-- ----------------------------
-- Table structure for "tb_sec_groups"
-- ----------------------------
DROP TABLE "tb_sec_groups";
CREATE TABLE "tb_sec_groups" (
"group_id"  INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
"group_description"  VARCHAR(45) COLLATE NOCASE NOT NULL
);

-- ----------------------------
-- Records of tb_sec_groups
-- ----------------------------
INSERT INTO "tb_sec_groups" VALUES (1, 'Contacts');
INSERT INTO "tb_sec_groups" VALUES (2, 'Candidates');
INSERT INTO "tb_sec_groups" VALUES (3, 'Administrator');

-- ----------------------------
-- Table structure for "tb_sec_groups_applications"
-- ----------------------------
DROP TABLE "tb_sec_groups_applications";
CREATE TABLE "tb_sec_groups_applications" (
"tb_sec_groups_group_id"  INTEGER(11) NOT NULL,
"tb_sec_applications_id"  VARCHAR(150) COLLATE NOCASE NOT NULL,
"priv_access"  VARCHAR(1) COLLATE NOCASE,
"priv_insert"  VARCHAR(1) COLLATE NOCASE,
"priv_delete"  VARCHAR(1) COLLATE NOCASE,
"priv_update"  VARCHAR(1) COLLATE NOCASE,
"priv_export"  VARCHAR(1) COLLATE NOCASE,
"priv_print"  VARCHAR(1) COLLATE NOCASE,
PRIMARY KEY ("tb_sec_groups_group_id", "tb_sec_applications_id")
);

-- ----------------------------
-- Records of tb_sec_groups_applications
-- ----------------------------
INSERT INTO "tb_sec_groups_applications" VALUES (1, 'control_change_psw', 'Y', null, null, null, null, null);
INSERT INTO "tb_sec_groups_applications" VALUES (1, 'form_add_candidate', null, null, null, null, null, null);
INSERT INTO "tb_sec_groups_applications" VALUES (1, 'form_add_company', null, null, null, null, null, null);
INSERT INTO "tb_sec_groups_applications" VALUES (1, 'form_add_contact', null, null, null, null, null, null);
INSERT INTO "tb_sec_groups_applications" VALUES (1, 'form_look_candidate', 'Y', 'Y', 'Y', 'Y', null, null);
INSERT INTO "tb_sec_groups_applications" VALUES (1, 'form_look_requisition', null, null, null, null, null, null);
INSERT INTO "tb_sec_groups_applications" VALUES (1, 'form_tb_benefits', 'Y', 'Y', 'Y', 'Y', null, null);
INSERT INTO "tb_sec_groups_applications" VALUES (1, 'form_tb_candidates_submissions', 'Y', 'Y', 'Y', 'Y', null, null);
INSERT INTO "tb_sec_groups_applications" VALUES (1, 'form_tb_companies', 'Y', 'Y', 'Y', 'Y', null, null);
INSERT INTO "tb_sec_groups_applications" VALUES (1, 'form_tb_contacts', 'Y', 'Y', 'Y', 'Y', null, null);
INSERT INTO "tb_sec_groups_applications" VALUES (1, 'form_tb_industries', 'Y', 'Y', 'Y', 'Y', null, null);
INSERT INTO "tb_sec_groups_applications" VALUES (1, 'form_tb_job_positions', 'Y', 'Y', 'Y', 'Y', null, null);
INSERT INTO "tb_sec_groups_applications" VALUES (1, 'form_tb_requisitions', 'Y', 'Y', 'Y', 'Y', null, null);
INSERT INTO "tb_sec_groups_applications" VALUES (1, 'form_tb_req_education', 'Y', 'Y', 'Y', 'Y', null, null);
INSERT INTO "tb_sec_groups_applications" VALUES (1, 'form_tb_req_status', 'Y', 'Y', 'Y', 'Y', null, null);
INSERT INTO "tb_sec_groups_applications" VALUES (1, 'form_tb_req_types', 'Y', 'Y', 'Y', 'Y', null, null);
INSERT INTO "tb_sec_groups_applications" VALUES (1, 'form_tb_req_urgencies', 'Y', 'Y', 'Y', 'Y', null, null);
INSERT INTO "tb_sec_groups_applications" VALUES (1, 'form_tb_submission_status', 'Y', 'Y', 'Y', 'Y', null, null);
INSERT INTO "tb_sec_groups_applications" VALUES (1, 'grid_submitted_candidate', null, null, null, null, null, null);
INSERT INTO "tb_sec_groups_applications" VALUES (1, 'grid_tb_benefits', 'Y', null, null, null, 'Y', 'Y');
INSERT INTO "tb_sec_groups_applications" VALUES (1, 'grid_tb_candidates_submissions', 'Y', null, null, null, 'Y', 'Y');
INSERT INTO "tb_sec_groups_applications" VALUES (1, 'grid_tb_companies', 'Y', null, null, null, 'Y', 'Y');
INSERT INTO "tb_sec_groups_applications" VALUES (1, 'grid_tb_contacts', 'Y', null, null, null, 'Y', 'Y');
INSERT INTO "tb_sec_groups_applications" VALUES (1, 'grid_tb_contacts_detail', 'Y', null, null, null, 'Y', 'Y');
INSERT INTO "tb_sec_groups_applications" VALUES (1, 'grid_tb_experiences', 'Y', null, null, null, 'Y', 'Y');
INSERT INTO "tb_sec_groups_applications" VALUES (1, 'grid_tb_industries', 'Y', null, null, null, 'Y', 'Y');
INSERT INTO "tb_sec_groups_applications" VALUES (1, 'grid_tb_job_positions', 'Y', null, null, null, 'Y', 'Y');
INSERT INTO "tb_sec_groups_applications" VALUES (1, 'grid_tb_requisitions', 'Y', null, null, null, 'Y', 'Y');
INSERT INTO "tb_sec_groups_applications" VALUES (1, 'grid_tb_requisitions_has_benefits', 'Y', null, null, null, 'Y', 'Y');
INSERT INTO "tb_sec_groups_applications" VALUES (1, 'grid_tb_req_education', 'Y', null, null, null, 'Y', 'Y');
INSERT INTO "tb_sec_groups_applications" VALUES (1, 'grid_tb_req_status', 'Y', null, null, null, 'Y', 'Y');
INSERT INTO "tb_sec_groups_applications" VALUES (1, 'grid_tb_req_types', 'Y', null, null, null, 'Y', 'Y');
INSERT INTO "tb_sec_groups_applications" VALUES (1, 'grid_tb_req_urgencies', 'Y', null, null, null, 'Y', 'Y');
INSERT INTO "tb_sec_groups_applications" VALUES (1, 'grid_tb_submission_status', 'Y', null, null, null, 'Y', 'Y');
INSERT INTO "tb_sec_groups_applications" VALUES (1, 'login', 'Y', null, null, null, null, null);
INSERT INTO "tb_sec_groups_applications" VALUES (1, 'menu', 'Y', null, null, null, null, null);
INSERT INTO "tb_sec_groups_applications" VALUES (2, 'blank_submit_candidate', 'Y', null, null, null, null, null);
INSERT INTO "tb_sec_groups_applications" VALUES (2, 'control_change_psw', 'Y', null, null, null, null, null);
INSERT INTO "tb_sec_groups_applications" VALUES (2, 'form_add_candidate', null, null, null, null, null, null);
INSERT INTO "tb_sec_groups_applications" VALUES (2, 'form_add_company', null, null, null, null, null, null);
INSERT INTO "tb_sec_groups_applications" VALUES (2, 'form_add_contact', null, null, null, null, null, null);
INSERT INTO "tb_sec_groups_applications" VALUES (2, 'form_edit_candidate', 'Y', 'Y', null, 'Y', null, null);
INSERT INTO "tb_sec_groups_applications" VALUES (2, 'form_look_requisition', 'Y', null, null, null, null, null);
INSERT INTO "tb_sec_groups_applications" VALUES (2, 'form_tb_candidates', 'Y', 'Y', null, 'Y', null, null);
INSERT INTO "tb_sec_groups_applications" VALUES (2, 'form_tb_experiences', 'Y', 'Y', 'Y', 'Y', null, null);
INSERT INTO "tb_sec_groups_applications" VALUES (2, 'grid_search_jobs', 'Y', null, null, null, 'Y', 'Y');
INSERT INTO "tb_sec_groups_applications" VALUES (2, 'grid_submitted_candidate', 'Y', null, null, null, 'Y', 'Y');
INSERT INTO "tb_sec_groups_applications" VALUES (2, 'grid_tb_experiences', 'Y', null, null, null, 'Y', 'Y');
INSERT INTO "tb_sec_groups_applications" VALUES (2, 'grid_tb_requisitions_has_benefits', 'Y', null, null, null, 'Y', 'Y');
INSERT INTO "tb_sec_groups_applications" VALUES (2, 'login', 'Y', null, null, null, null, null);
INSERT INTO "tb_sec_groups_applications" VALUES (2, 'menu', 'Y', null, null, null, null, null);
INSERT INTO "tb_sec_groups_applications" VALUES (3, 'app_grid_log', 'Y', null, null, null, 'Y', 'Y');
INSERT INTO "tb_sec_groups_applications" VALUES (3, 'blank_submit_candidate', 'Y', null, null, null, null, null);
INSERT INTO "tb_sec_groups_applications" VALUES (3, 'control_change_psw', 'Y', null, null, null, null, null);
INSERT INTO "tb_sec_groups_applications" VALUES (3, 'control_sync_apps', 'Y', null, null, null, null, null);
INSERT INTO "tb_sec_groups_applications" VALUES (3, 'form_add_candidate', 'Y', 'Y', 'Y', 'Y', null, null);
INSERT INTO "tb_sec_groups_applications" VALUES (3, 'form_add_company', 'Y', 'Y', 'Y', 'Y', null, null);
INSERT INTO "tb_sec_groups_applications" VALUES (3, 'form_add_contact', 'Y', 'Y', 'Y', 'Y', null, null);
INSERT INTO "tb_sec_groups_applications" VALUES (3, 'form_edit_candidate', null, null, null, null, null, null);
INSERT INTO "tb_sec_groups_applications" VALUES (3, 'form_look_candidate', 'Y', 'Y', 'Y', 'Y', null, null);
INSERT INTO "tb_sec_groups_applications" VALUES (3, 'form_look_requisition', 'Y', 'Y', 'Y', 'Y', null, null);
INSERT INTO "tb_sec_groups_applications" VALUES (3, 'form_tb_benefits', 'Y', 'Y', 'Y', 'Y', null, null);
INSERT INTO "tb_sec_groups_applications" VALUES (3, 'form_tb_candidates', 'Y', 'Y', 'Y', 'Y', null, null);
INSERT INTO "tb_sec_groups_applications" VALUES (3, 'form_tb_candidates_submissions', 'Y', 'Y', 'Y', 'Y', null, null);
INSERT INTO "tb_sec_groups_applications" VALUES (3, 'form_tb_companies', 'Y', 'Y', 'Y', 'Y', null, null);
INSERT INTO "tb_sec_groups_applications" VALUES (3, 'form_tb_contacts', 'Y', 'Y', 'Y', 'Y', null, null);
INSERT INTO "tb_sec_groups_applications" VALUES (3, 'form_tb_experiences', 'Y', 'Y', 'Y', 'Y', null, null);
INSERT INTO "tb_sec_groups_applications" VALUES (3, 'form_tb_industries', 'Y', 'Y', 'Y', 'Y', null, null);
INSERT INTO "tb_sec_groups_applications" VALUES (3, 'form_tb_job_positions', 'Y', 'Y', 'Y', 'Y', null, null);
INSERT INTO "tb_sec_groups_applications" VALUES (3, 'form_tb_requisitions', 'Y', 'Y', 'Y', 'Y', null, null);
INSERT INTO "tb_sec_groups_applications" VALUES (3, 'form_tb_req_education', 'Y', 'Y', 'Y', 'Y', null, null);
INSERT INTO "tb_sec_groups_applications" VALUES (3, 'form_tb_req_status', 'Y', 'Y', 'Y', 'Y', null, null);
INSERT INTO "tb_sec_groups_applications" VALUES (3, 'form_tb_req_types', 'Y', 'Y', 'Y', 'Y', null, null);
INSERT INTO "tb_sec_groups_applications" VALUES (3, 'form_tb_req_urgencies', 'Y', 'Y', 'Y', 'Y', null, null);
INSERT INTO "tb_sec_groups_applications" VALUES (3, 'form_tb_sec_applications', 'Y', 'Y', 'Y', 'Y', null, null);
INSERT INTO "tb_sec_groups_applications" VALUES (3, 'form_tb_sec_groups', 'Y', 'Y', 'Y', 'Y', null, null);
INSERT INTO "tb_sec_groups_applications" VALUES (3, 'form_tb_sec_groups_applications', 'Y', 'Y', 'Y', 'Y', null, null);
INSERT INTO "tb_sec_groups_applications" VALUES (3, 'form_tb_submission_status', 'Y', 'Y', 'Y', 'Y', null, null);
INSERT INTO "tb_sec_groups_applications" VALUES (3, 'grid_search_jobs', 'Y', null, null, null, 'Y', 'Y');
INSERT INTO "tb_sec_groups_applications" VALUES (3, 'grid_submitted_candidate', 'Y', null, null, null, 'Y', 'Y');
INSERT INTO "tb_sec_groups_applications" VALUES (3, 'grid_tb_benefits', 'Y', null, null, null, 'Y', 'Y');
INSERT INTO "tb_sec_groups_applications" VALUES (3, 'grid_tb_candidates', 'Y', null, null, null, 'Y', 'Y');
INSERT INTO "tb_sec_groups_applications" VALUES (3, 'grid_tb_candidates_submissions', 'Y', null, null, null, 'Y', 'Y');
INSERT INTO "tb_sec_groups_applications" VALUES (3, 'grid_tb_companies', 'Y', null, null, null, 'Y', 'Y');
INSERT INTO "tb_sec_groups_applications" VALUES (3, 'grid_tb_contacts', 'Y', null, null, null, 'Y', 'Y');
INSERT INTO "tb_sec_groups_applications" VALUES (3, 'grid_tb_contacts_detail', 'Y', null, null, null, 'Y', 'Y');
INSERT INTO "tb_sec_groups_applications" VALUES (3, 'grid_tb_experiences', 'Y', null, null, null, 'Y', 'Y');
INSERT INTO "tb_sec_groups_applications" VALUES (3, 'grid_tb_industries', 'Y', null, null, null, 'Y', 'Y');
INSERT INTO "tb_sec_groups_applications" VALUES (3, 'grid_tb_job_positions', 'Y', null, null, null, 'Y', 'Y');
INSERT INTO "tb_sec_groups_applications" VALUES (3, 'grid_tb_requisitions', 'Y', null, null, null, 'Y', 'Y');
INSERT INTO "tb_sec_groups_applications" VALUES (3, 'grid_tb_requisitions_has_benefits', 'Y', null, null, null, 'Y', 'Y');
INSERT INTO "tb_sec_groups_applications" VALUES (3, 'grid_tb_req_education', 'Y', null, null, null, 'Y', 'Y');
INSERT INTO "tb_sec_groups_applications" VALUES (3, 'grid_tb_req_status', 'Y', null, null, null, 'Y', 'Y');
INSERT INTO "tb_sec_groups_applications" VALUES (3, 'grid_tb_req_types', 'Y', null, null, null, 'Y', 'Y');
INSERT INTO "tb_sec_groups_applications" VALUES (3, 'grid_tb_req_urgencies', 'Y', null, null, null, 'Y', 'Y');
INSERT INTO "tb_sec_groups_applications" VALUES (3, 'grid_tb_sec_applications', 'Y', null, null, null, 'Y', 'Y');
INSERT INTO "tb_sec_groups_applications" VALUES (3, 'grid_tb_sec_groups', 'Y', null, null, null, 'Y', 'Y');
INSERT INTO "tb_sec_groups_applications" VALUES (3, 'grid_tb_submission_status', 'Y', null, null, null, 'Y', 'Y');
INSERT INTO "tb_sec_groups_applications" VALUES (3, 'login', 'Y', null, null, null, null, null);
INSERT INTO "tb_sec_groups_applications" VALUES (3, 'menu', 'Y', null, null, null, null, null);
INSERT INTO "tb_sec_groups_applications" VALUES (3, 'search_tb_sec_groups', 'Y', null, null, null, null, null);

-- ----------------------------
-- Table structure for "tb_sec_users"
-- ----------------------------
DROP TABLE "tb_sec_users";
CREATE TABLE "tb_sec_users" (
"user_login"  VARCHAR(50) COLLATE NOCASE NOT NULL,
"user_password"  VARCHAR(150) COLLATE NOCASE NOT NULL,
"tb_sec_groups_group_id"  INTEGER(11) NOT NULL,
PRIMARY KEY ("user_login")
);

-- ----------------------------
-- Records of tb_sec_users
-- ----------------------------
INSERT INTO "tb_sec_users" VALUES ('admin', 'admin', 3);
INSERT INTO "tb_sec_users" VALUES ('alice', 'alice', 1);
INSERT INTO "tb_sec_users" VALUES ('andy', 'andy', 1);
INSERT INTO "tb_sec_users" VALUES ('eldrich', 'eldrich', 2);
INSERT INTO "tb_sec_users" VALUES ('mary', 'mary', 2);
INSERT INTO "tb_sec_users" VALUES ('mayer', 'mayer', 1);
INSERT INTO "tb_sec_users" VALUES ('paul', 'paul', 1);
INSERT INTO "tb_sec_users" VALUES ('phill', 'phill', 1);

-- ----------------------------
-- Table structure for "tb_submission_status"
-- ----------------------------
DROP TABLE "tb_submission_status";
CREATE TABLE "tb_submission_status" (
"submission_status_id"  INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
"submission_status_description"  VARCHAR(45) COLLATE NOCASE NOT NULL
);

-- ----------------------------
-- Records of tb_submission_status
-- ----------------------------
INSERT INTO "tb_submission_status" VALUES (1, 'Submitted');
INSERT INTO "tb_submission_status" VALUES (2, 'Rejected');
INSERT INTO "tb_submission_status" VALUES (3, 'Scheduled');
INSERT INTO "tb_submission_status" VALUES (4, 'Cancelled');
INSERT INTO "tb_submission_status" VALUES (5, 'Hired');
